<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserDataFromSessionIdResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetUserDataFromSessionIdResponse
 * @subpackage Structs
 */
class GetUserDataFromSessionIdResponse extends Response
{
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AddressId;
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContactPersonId;
    /**
     * The DateOfLastLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfLastLogin;
    /**
     * The DateOfRegistration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfRegistration;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SessionId;
    /**
     * The UserAddressData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserAddressData
     */
    public $UserAddressData;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserId;
    /**
     * The GetUserDataFromSessionIdResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetUserDataFromSessionIdResponse
     */
    public $GetUserDataFromSessionIdResult;
    /**
     * Constructor method for GetUserDataFromSessionIdResponse
     * @uses GetUserDataFromSessionIdResponse::setAddressId()
     * @uses GetUserDataFromSessionIdResponse::setContactPersonId()
     * @uses GetUserDataFromSessionIdResponse::setDateOfLastLogin()
     * @uses GetUserDataFromSessionIdResponse::setDateOfRegistration()
     * @uses GetUserDataFromSessionIdResponse::setSessionId()
     * @uses GetUserDataFromSessionIdResponse::setUserAddressData()
     * @uses GetUserDataFromSessionIdResponse::setUserId()
     * @uses GetUserDataFromSessionIdResponse::setGetUserDataFromSessionIdResult()
     * @param int $addressId
     * @param int $contactPersonId
     * @param string $dateOfLastLogin
     * @param string $dateOfRegistration
     * @param string $sessionId
     * @param \StructType\UserAddressData $userAddressData
     * @param int $userId
     * @param \StructType\GetUserDataFromSessionIdResponse $getUserDataFromSessionIdResult
     */
    public function __construct($addressId = null, $contactPersonId = null, $dateOfLastLogin = null, $dateOfRegistration = null, $sessionId = null, \StructType\UserAddressData $userAddressData = null, $userId = null, \StructType\GetUserDataFromSessionIdResponse $getUserDataFromSessionIdResult = null)
    {
        $this
            ->setAddressId($addressId)
            ->setContactPersonId($contactPersonId)
            ->setDateOfLastLogin($dateOfLastLogin)
            ->setDateOfRegistration($dateOfRegistration)
            ->setSessionId($sessionId)
            ->setUserAddressData($userAddressData)
            ->setUserId($userId)
            ->setGetUserDataFromSessionIdResult($getUserDataFromSessionIdResult);
    }
    /**
     * Get AddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAddressId()
    {
        return isset($this->AddressId) ? $this->AddressId : null;
    }
    /**
     * Set AddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $addressId
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        if (is_null($addressId) || (is_array($addressId) && empty($addressId))) {
            unset($this->AddressId);
        } else {
            $this->AddressId = $addressId;
        }
        return $this;
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contactPersonId
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: int
        if (!is_null($contactPersonId) && !(is_int($contactPersonId) || ctype_digit($contactPersonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get DateOfLastLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfLastLogin()
    {
        return isset($this->DateOfLastLogin) ? $this->DateOfLastLogin : null;
    }
    /**
     * Set DateOfLastLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfLastLogin
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setDateOfLastLogin($dateOfLastLogin = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfLastLogin) && !is_string($dateOfLastLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfLastLogin, true), gettype($dateOfLastLogin)), __LINE__);
        }
        if (is_null($dateOfLastLogin) || (is_array($dateOfLastLogin) && empty($dateOfLastLogin))) {
            unset($this->DateOfLastLogin);
        } else {
            $this->DateOfLastLogin = $dateOfLastLogin;
        }
        return $this;
    }
    /**
     * Get DateOfRegistration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfRegistration()
    {
        return isset($this->DateOfRegistration) ? $this->DateOfRegistration : null;
    }
    /**
     * Set DateOfRegistration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfRegistration
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setDateOfRegistration($dateOfRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfRegistration) && !is_string($dateOfRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfRegistration, true), gettype($dateOfRegistration)), __LINE__);
        }
        if (is_null($dateOfRegistration) || (is_array($dateOfRegistration) && empty($dateOfRegistration))) {
            unset($this->DateOfRegistration);
        } else {
            $this->DateOfRegistration = $dateOfRegistration;
        }
        return $this;
    }
    /**
     * Get SessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->SessionId) ? $this->SessionId : null;
    }
    /**
     * Set SessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionId
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sessionId, true)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->SessionId);
        } else {
            $this->SessionId = $sessionId;
        }
        return $this;
    }
    /**
     * Get UserAddressData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserAddressData|null
     */
    public function getUserAddressData()
    {
        return isset($this->UserAddressData) ? $this->UserAddressData : null;
    }
    /**
     * Set UserAddressData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UserAddressData $userAddressData
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setUserAddressData(\StructType\UserAddressData $userAddressData = null)
    {
        if (is_null($userAddressData) || (is_array($userAddressData) && empty($userAddressData))) {
            unset($this->UserAddressData);
        } else {
            $this->UserAddressData = $userAddressData;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userId
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get GetUserDataFromSessionIdResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetUserDataFromSessionIdResponse|null
     */
    public function getGetUserDataFromSessionIdResult()
    {
        return isset($this->GetUserDataFromSessionIdResult) ? $this->GetUserDataFromSessionIdResult : null;
    }
    /**
     * Set GetUserDataFromSessionIdResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetUserDataFromSessionIdResponse $getUserDataFromSessionIdResult
     * @return \StructType\GetUserDataFromSessionIdResponse
     */
    public function setGetUserDataFromSessionIdResult(\StructType\GetUserDataFromSessionIdResponse $getUserDataFromSessionIdResult = null)
    {
        if (is_null($getUserDataFromSessionIdResult) || (is_array($getUserDataFromSessionIdResult) && empty($getUserDataFromSessionIdResult))) {
            unset($this->GetUserDataFromSessionIdResult);
        } else {
            $this->GetUserDataFromSessionIdResult = $getUserDataFromSessionIdResult;
        }
        return $this;
    }
}
