<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetExternalSessionId $parameters
     * @return \StructType\SetExternalSessionIdResponse|bool
     */
    public function SetExternalSessionId(\StructType\SetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetExternalSessionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
