<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Newsletter ServiceType
 * @subpackage Services
 */
class Newsletter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NewsletterConfirmDoubleOptIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewsletterConfirmDoubleOptIn $parameters
     * @return \StructType\NewsletterConfirmDoubleOptInResponse|bool
     */
    public function NewsletterConfirmDoubleOptIn(\StructType\NewsletterConfirmDoubleOptIn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NewsletterConfirmDoubleOptIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NewsletterUnsubscribe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewsletterUnsubscribe $parameters
     * @return \StructType\NewsletterUnsubscribeResponse|bool
     */
    public function NewsletterUnsubscribe(\StructType\NewsletterUnsubscribe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NewsletterUnsubscribe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NewsletterConfirmDoubleOptInResponse|\StructType\NewsletterUnsubscribeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
