<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetUserDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserDataFromSessionId $parameters
     * @return \StructType\GetUserDataFromSessionIdResponse|bool
     */
    public function GetUserDataFromSessionId(\StructType\GetUserDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalesDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSalesDataFromSessionId $parameters
     * @return \StructType\GetSalesDataFromSessionIdResponse|bool
     */
    public function GetSalesDataFromSessionId(\StructType\GetSalesDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalesDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllLoginsForAddressOfThisSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllLoginsForAddressOfThisSessionId $parameters
     * @return \StructType\GetAllLoginsForAddressOfThisSessionIdResponse|bool
     */
    public function GetAllLoginsForAddressOfThisSessionId(\StructType\GetAllLoginsForAddressOfThisSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllLoginsForAddressOfThisSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExternalSessionId $parameters
     * @return \StructType\GetExternalSessionIdResponse|bool
     */
    public function GetExternalSessionId(\StructType\GetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllLoginsForAddressOfThisSessionIdResponse|\StructType\GetExternalSessionIdResponse|\StructType\GetSalesDataFromSessionIdResponse|\StructType\GetUserDataFromSessionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
