<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuccessfullyDeleted StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SuccessfullyDeleted
 * @subpackage Structs
 */
class SuccessfullyDeleted extends AbstractStructBase
{
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The SubParcelIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $SubParcelIdList;
    /**
     * Constructor method for SuccessfullyDeleted
     * @uses SuccessfullyDeleted::setParcelId()
     * @uses SuccessfullyDeleted::setSubParcelIdList()
     * @param int $parcelId
     * @param \ArrayType\ArrayOfint $subParcelIdList
     */
    public function __construct($parcelId = null, \ArrayType\ArrayOfint $subParcelIdList = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setSubParcelIdList($subParcelIdList);
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \StructType\SuccessfullyDeleted
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get SubParcelIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getSubParcelIdList()
    {
        return isset($this->SubParcelIdList) ? $this->SubParcelIdList : null;
    }
    /**
     * Set SubParcelIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $subParcelIdList
     * @return \StructType\SuccessfullyDeleted
     */
    public function setSubParcelIdList(\ArrayType\ArrayOfint $subParcelIdList = null)
    {
        if (is_null($subParcelIdList) || (is_array($subParcelIdList) && empty($subParcelIdList))) {
            unset($this->SubParcelIdList);
        } else {
            $this->SubParcelIdList = $subParcelIdList;
        }
        return $this;
    }
}
