<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceParameterStringDecimal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceParameterStringDecimal
 * @subpackage Structs
 */
class ServiceParameterStringDecimal extends AbstractStructBase
{
    /**
     * The DecimalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DecimalValue;
    /**
     * The StringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringValue;
    /**
     * Constructor method for ServiceParameterStringDecimal
     * @uses ServiceParameterStringDecimal::setDecimalValue()
     * @uses ServiceParameterStringDecimal::setStringValue()
     * @param float $decimalValue
     * @param string $stringValue
     */
    public function __construct($decimalValue = null, $stringValue = null)
    {
        $this
            ->setDecimalValue($decimalValue)
            ->setStringValue($stringValue);
    }
    /**
     * Get DecimalValue value
     * @return float|null
     */
    public function getDecimalValue()
    {
        return $this->DecimalValue;
    }
    /**
     * Set DecimalValue value
     * @param float $decimalValue
     * @return \StructType\ServiceParameterStringDecimal
     */
    public function setDecimalValue($decimalValue = null)
    {
        // validation for constraint: float
        if (!is_null($decimalValue) && !(is_float($decimalValue) || is_numeric($decimalValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimalValue, true), gettype($decimalValue)), __LINE__);
        }
        $this->DecimalValue = $decimalValue;
        return $this;
    }
    /**
     * Get StringValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringValue()
    {
        return isset($this->StringValue) ? $this->StringValue : null;
    }
    /**
     * Set StringValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringValue
     * @return \StructType\ServiceParameterStringDecimal
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        if (is_null($stringValue) || (is_array($stringValue) && empty($stringValue))) {
            unset($this->StringValue);
        } else {
            $this->StringValue = $stringValue;
        }
        return $this;
    }
}
