<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Service
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The ADRParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterADR
     */
    public $ADRParameter;
    /**
     * The AOSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $AOSParameter;
    /**
     * The CS1Parameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $CS1Parameter;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The DDSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterDateTime
     */
    public $DDSParameter;
    /**
     * The DPVParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterStringDecimal
     */
    public $DPVParameter;
    /**
     * The FDSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $FDSParameter;
    /**
     * The FSSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $FSSParameter;
    /**
     * The INSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterDecimal
     */
    public $INSParameter;
    /**
     * The MMPParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterDecimal
     */
    public $MMPParameter;
    /**
     * The PSDParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterStringInteger
     */
    public $PSDParameter;
    /**
     * The SDSParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterTimeRange
     */
    public $SDSParameter;
    /**
     * The SM1Parameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $SM1Parameter;
    /**
     * The SM2Parameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $SM2Parameter;
    /**
     * The SZLParameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceParameterString
     */
    public $SZLParameter;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for Service
     * @uses Service::setADRParameter()
     * @uses Service::setAOSParameter()
     * @uses Service::setCS1Parameter()
     * @uses Service::setCode()
     * @uses Service::setDDSParameter()
     * @uses Service::setDPVParameter()
     * @uses Service::setFDSParameter()
     * @uses Service::setFSSParameter()
     * @uses Service::setINSParameter()
     * @uses Service::setMMPParameter()
     * @uses Service::setPSDParameter()
     * @uses Service::setSDSParameter()
     * @uses Service::setSM1Parameter()
     * @uses Service::setSM2Parameter()
     * @uses Service::setSZLParameter()
     * @uses Service::setValue()
     * @param \StructType\ServiceParameterADR $aDRParameter
     * @param \StructType\ServiceParameterString $aOSParameter
     * @param \StructType\ServiceParameterString $cS1Parameter
     * @param string $code
     * @param \StructType\ServiceParameterDateTime $dDSParameter
     * @param \StructType\ServiceParameterStringDecimal $dPVParameter
     * @param \StructType\ServiceParameterString $fDSParameter
     * @param \StructType\ServiceParameterString $fSSParameter
     * @param \StructType\ServiceParameterDecimal $iNSParameter
     * @param \StructType\ServiceParameterDecimal $mMPParameter
     * @param \StructType\ServiceParameterStringInteger $pSDParameter
     * @param \StructType\ServiceParameterTimeRange $sDSParameter
     * @param \StructType\ServiceParameterString $sM1Parameter
     * @param \StructType\ServiceParameterString $sM2Parameter
     * @param \StructType\ServiceParameterString $sZLParameter
     * @param string $value
     */
    public function __construct(\StructType\ServiceParameterADR $aDRParameter = null, \StructType\ServiceParameterString $aOSParameter = null, \StructType\ServiceParameterString $cS1Parameter = null, $code = null, \StructType\ServiceParameterDateTime $dDSParameter = null, \StructType\ServiceParameterStringDecimal $dPVParameter = null, \StructType\ServiceParameterString $fDSParameter = null, \StructType\ServiceParameterString $fSSParameter = null, \StructType\ServiceParameterDecimal $iNSParameter = null, \StructType\ServiceParameterDecimal $mMPParameter = null, \StructType\ServiceParameterStringInteger $pSDParameter = null, \StructType\ServiceParameterTimeRange $sDSParameter = null, \StructType\ServiceParameterString $sM1Parameter = null, \StructType\ServiceParameterString $sM2Parameter = null, \StructType\ServiceParameterString $sZLParameter = null, $value = null)
    {
        $this
            ->setADRParameter($aDRParameter)
            ->setAOSParameter($aOSParameter)
            ->setCS1Parameter($cS1Parameter)
            ->setCode($code)
            ->setDDSParameter($dDSParameter)
            ->setDPVParameter($dPVParameter)
            ->setFDSParameter($fDSParameter)
            ->setFSSParameter($fSSParameter)
            ->setINSParameter($iNSParameter)
            ->setMMPParameter($mMPParameter)
            ->setPSDParameter($pSDParameter)
            ->setSDSParameter($sDSParameter)
            ->setSM1Parameter($sM1Parameter)
            ->setSM2Parameter($sM2Parameter)
            ->setSZLParameter($sZLParameter)
            ->setValue($value);
    }
    /**
     * Get ADRParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterADR|null
     */
    public function getADRParameter()
    {
        return isset($this->ADRParameter) ? $this->ADRParameter : null;
    }
    /**
     * Set ADRParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterADR $aDRParameter
     * @return \StructType\Service
     */
    public function setADRParameter(\StructType\ServiceParameterADR $aDRParameter = null)
    {
        if (is_null($aDRParameter) || (is_array($aDRParameter) && empty($aDRParameter))) {
            unset($this->ADRParameter);
        } else {
            $this->ADRParameter = $aDRParameter;
        }
        return $this;
    }
    /**
     * Get AOSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getAOSParameter()
    {
        return isset($this->AOSParameter) ? $this->AOSParameter : null;
    }
    /**
     * Set AOSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $aOSParameter
     * @return \StructType\Service
     */
    public function setAOSParameter(\StructType\ServiceParameterString $aOSParameter = null)
    {
        if (is_null($aOSParameter) || (is_array($aOSParameter) && empty($aOSParameter))) {
            unset($this->AOSParameter);
        } else {
            $this->AOSParameter = $aOSParameter;
        }
        return $this;
    }
    /**
     * Get CS1Parameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getCS1Parameter()
    {
        return isset($this->CS1Parameter) ? $this->CS1Parameter : null;
    }
    /**
     * Set CS1Parameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $cS1Parameter
     * @return \StructType\Service
     */
    public function setCS1Parameter(\StructType\ServiceParameterString $cS1Parameter = null)
    {
        if (is_null($cS1Parameter) || (is_array($cS1Parameter) && empty($cS1Parameter))) {
            unset($this->CS1Parameter);
        } else {
            $this->CS1Parameter = $cS1Parameter;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\Service
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get DDSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterDateTime|null
     */
    public function getDDSParameter()
    {
        return isset($this->DDSParameter) ? $this->DDSParameter : null;
    }
    /**
     * Set DDSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterDateTime $dDSParameter
     * @return \StructType\Service
     */
    public function setDDSParameter(\StructType\ServiceParameterDateTime $dDSParameter = null)
    {
        if (is_null($dDSParameter) || (is_array($dDSParameter) && empty($dDSParameter))) {
            unset($this->DDSParameter);
        } else {
            $this->DDSParameter = $dDSParameter;
        }
        return $this;
    }
    /**
     * Get DPVParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterStringDecimal|null
     */
    public function getDPVParameter()
    {
        return isset($this->DPVParameter) ? $this->DPVParameter : null;
    }
    /**
     * Set DPVParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterStringDecimal $dPVParameter
     * @return \StructType\Service
     */
    public function setDPVParameter(\StructType\ServiceParameterStringDecimal $dPVParameter = null)
    {
        if (is_null($dPVParameter) || (is_array($dPVParameter) && empty($dPVParameter))) {
            unset($this->DPVParameter);
        } else {
            $this->DPVParameter = $dPVParameter;
        }
        return $this;
    }
    /**
     * Get FDSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getFDSParameter()
    {
        return isset($this->FDSParameter) ? $this->FDSParameter : null;
    }
    /**
     * Set FDSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $fDSParameter
     * @return \StructType\Service
     */
    public function setFDSParameter(\StructType\ServiceParameterString $fDSParameter = null)
    {
        if (is_null($fDSParameter) || (is_array($fDSParameter) && empty($fDSParameter))) {
            unset($this->FDSParameter);
        } else {
            $this->FDSParameter = $fDSParameter;
        }
        return $this;
    }
    /**
     * Get FSSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getFSSParameter()
    {
        return isset($this->FSSParameter) ? $this->FSSParameter : null;
    }
    /**
     * Set FSSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $fSSParameter
     * @return \StructType\Service
     */
    public function setFSSParameter(\StructType\ServiceParameterString $fSSParameter = null)
    {
        if (is_null($fSSParameter) || (is_array($fSSParameter) && empty($fSSParameter))) {
            unset($this->FSSParameter);
        } else {
            $this->FSSParameter = $fSSParameter;
        }
        return $this;
    }
    /**
     * Get INSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterDecimal|null
     */
    public function getINSParameter()
    {
        return isset($this->INSParameter) ? $this->INSParameter : null;
    }
    /**
     * Set INSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterDecimal $iNSParameter
     * @return \StructType\Service
     */
    public function setINSParameter(\StructType\ServiceParameterDecimal $iNSParameter = null)
    {
        if (is_null($iNSParameter) || (is_array($iNSParameter) && empty($iNSParameter))) {
            unset($this->INSParameter);
        } else {
            $this->INSParameter = $iNSParameter;
        }
        return $this;
    }
    /**
     * Get MMPParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterDecimal|null
     */
    public function getMMPParameter()
    {
        return isset($this->MMPParameter) ? $this->MMPParameter : null;
    }
    /**
     * Set MMPParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterDecimal $mMPParameter
     * @return \StructType\Service
     */
    public function setMMPParameter(\StructType\ServiceParameterDecimal $mMPParameter = null)
    {
        if (is_null($mMPParameter) || (is_array($mMPParameter) && empty($mMPParameter))) {
            unset($this->MMPParameter);
        } else {
            $this->MMPParameter = $mMPParameter;
        }
        return $this;
    }
    /**
     * Get PSDParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterStringInteger|null
     */
    public function getPSDParameter()
    {
        return isset($this->PSDParameter) ? $this->PSDParameter : null;
    }
    /**
     * Set PSDParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterStringInteger $pSDParameter
     * @return \StructType\Service
     */
    public function setPSDParameter(\StructType\ServiceParameterStringInteger $pSDParameter = null)
    {
        if (is_null($pSDParameter) || (is_array($pSDParameter) && empty($pSDParameter))) {
            unset($this->PSDParameter);
        } else {
            $this->PSDParameter = $pSDParameter;
        }
        return $this;
    }
    /**
     * Get SDSParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterTimeRange|null
     */
    public function getSDSParameter()
    {
        return isset($this->SDSParameter) ? $this->SDSParameter : null;
    }
    /**
     * Set SDSParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterTimeRange $sDSParameter
     * @return \StructType\Service
     */
    public function setSDSParameter(\StructType\ServiceParameterTimeRange $sDSParameter = null)
    {
        if (is_null($sDSParameter) || (is_array($sDSParameter) && empty($sDSParameter))) {
            unset($this->SDSParameter);
        } else {
            $this->SDSParameter = $sDSParameter;
        }
        return $this;
    }
    /**
     * Get SM1Parameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getSM1Parameter()
    {
        return isset($this->SM1Parameter) ? $this->SM1Parameter : null;
    }
    /**
     * Set SM1Parameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $sM1Parameter
     * @return \StructType\Service
     */
    public function setSM1Parameter(\StructType\ServiceParameterString $sM1Parameter = null)
    {
        if (is_null($sM1Parameter) || (is_array($sM1Parameter) && empty($sM1Parameter))) {
            unset($this->SM1Parameter);
        } else {
            $this->SM1Parameter = $sM1Parameter;
        }
        return $this;
    }
    /**
     * Get SM2Parameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getSM2Parameter()
    {
        return isset($this->SM2Parameter) ? $this->SM2Parameter : null;
    }
    /**
     * Set SM2Parameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $sM2Parameter
     * @return \StructType\Service
     */
    public function setSM2Parameter(\StructType\ServiceParameterString $sM2Parameter = null)
    {
        if (is_null($sM2Parameter) || (is_array($sM2Parameter) && empty($sM2Parameter))) {
            unset($this->SM2Parameter);
        } else {
            $this->SM2Parameter = $sM2Parameter;
        }
        return $this;
    }
    /**
     * Get SZLParameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceParameterString|null
     */
    public function getSZLParameter()
    {
        return isset($this->SZLParameter) ? $this->SZLParameter : null;
    }
    /**
     * Set SZLParameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ServiceParameterString $sZLParameter
     * @return \StructType\Service
     */
    public function setSZLParameter(\StructType\ServiceParameterString $sZLParameter = null)
    {
        if (is_null($sZLParameter) || (is_array($sZLParameter) && empty($sZLParameter))) {
            unset($this->SZLParameter);
        } else {
            $this->SZLParameter = $sZLParameter;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\Service
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
