<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelsInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrintLabelsInfo
 * @subpackage Structs
 */
class PrintLabelsInfo extends ParcelInfo
{
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelNumber;
    /**
     * Constructor method for PrintLabelsInfo
     * @uses PrintLabelsInfo::setParcelNumber()
     * @param int $parcelNumber
     */
    public function __construct($parcelNumber = null)
    {
        $this
            ->setParcelNumber($parcelNumber);
    }
    /**
     * Get ParcelNumber value
     * @return int|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\PrintLabelsInfo
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
}
