<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintDataInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrintDataInfo
 * @subpackage Structs
 */
class PrintDataInfo extends AbstractStructBase
{
    /**
     * The B2CChar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $B2CChar;
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The Depot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Depot;
    /**
     * The DepotNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepotNumber;
    /**
     * The Driver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Driver;
    /**
     * The Parcel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Parcel
     */
    public $Parcel;
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelNumber;
    /**
     * The ParcelNumberWithCheckdigit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelNumberWithCheckdigit;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sort;
    /**
     * Constructor method for PrintDataInfo
     * @uses PrintDataInfo::setB2CChar()
     * @uses PrintDataInfo::setClientReference()
     * @uses PrintDataInfo::setDepot()
     * @uses PrintDataInfo::setDepotNumber()
     * @uses PrintDataInfo::setDriver()
     * @uses PrintDataInfo::setParcel()
     * @uses PrintDataInfo::setParcelId()
     * @uses PrintDataInfo::setParcelNumber()
     * @uses PrintDataInfo::setParcelNumberWithCheckdigit()
     * @uses PrintDataInfo::setSort()
     * @param string $b2CChar
     * @param string $clientReference
     * @param string $depot
     * @param string $depotNumber
     * @param string $driver
     * @param \StructType\Parcel $parcel
     * @param int $parcelId
     * @param int $parcelNumber
     * @param int $parcelNumberWithCheckdigit
     * @param string $sort
     */
    public function __construct($b2CChar = null, $clientReference = null, $depot = null, $depotNumber = null, $driver = null, \StructType\Parcel $parcel = null, $parcelId = null, $parcelNumber = null, $parcelNumberWithCheckdigit = null, $sort = null)
    {
        $this
            ->setB2CChar($b2CChar)
            ->setClientReference($clientReference)
            ->setDepot($depot)
            ->setDepotNumber($depotNumber)
            ->setDriver($driver)
            ->setParcel($parcel)
            ->setParcelId($parcelId)
            ->setParcelNumber($parcelNumber)
            ->setParcelNumberWithCheckdigit($parcelNumberWithCheckdigit)
            ->setSort($sort);
    }
    /**
     * Get B2CChar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getB2CChar()
    {
        return isset($this->B2CChar) ? $this->B2CChar : null;
    }
    /**
     * Set B2CChar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $b2CChar
     * @return \StructType\PrintDataInfo
     */
    public function setB2CChar($b2CChar = null)
    {
        // validation for constraint: string
        if (!is_null($b2CChar) && !is_string($b2CChar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($b2CChar, true), gettype($b2CChar)), __LINE__);
        }
        if (is_null($b2CChar) || (is_array($b2CChar) && empty($b2CChar))) {
            unset($this->B2CChar);
        } else {
            $this->B2CChar = $b2CChar;
        }
        return $this;
    }
    /**
     * Get ClientReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReference()
    {
        return isset($this->ClientReference) ? $this->ClientReference : null;
    }
    /**
     * Set ClientReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReference
     * @return \StructType\PrintDataInfo
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        if (is_null($clientReference) || (is_array($clientReference) && empty($clientReference))) {
            unset($this->ClientReference);
        } else {
            $this->ClientReference = $clientReference;
        }
        return $this;
    }
    /**
     * Get Depot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepot()
    {
        return isset($this->Depot) ? $this->Depot : null;
    }
    /**
     * Set Depot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depot
     * @return \StructType\PrintDataInfo
     */
    public function setDepot($depot = null)
    {
        // validation for constraint: string
        if (!is_null($depot) && !is_string($depot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depot, true), gettype($depot)), __LINE__);
        }
        if (is_null($depot) || (is_array($depot) && empty($depot))) {
            unset($this->Depot);
        } else {
            $this->Depot = $depot;
        }
        return $this;
    }
    /**
     * Get DepotNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepotNumber()
    {
        return isset($this->DepotNumber) ? $this->DepotNumber : null;
    }
    /**
     * Set DepotNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depotNumber
     * @return \StructType\PrintDataInfo
     */
    public function setDepotNumber($depotNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depotNumber) && !is_string($depotNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depotNumber, true), gettype($depotNumber)), __LINE__);
        }
        if (is_null($depotNumber) || (is_array($depotNumber) && empty($depotNumber))) {
            unset($this->DepotNumber);
        } else {
            $this->DepotNumber = $depotNumber;
        }
        return $this;
    }
    /**
     * Get Driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriver()
    {
        return isset($this->Driver) ? $this->Driver : null;
    }
    /**
     * Set Driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driver
     * @return \StructType\PrintDataInfo
     */
    public function setDriver($driver = null)
    {
        // validation for constraint: string
        if (!is_null($driver) && !is_string($driver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver, true), gettype($driver)), __LINE__);
        }
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->Driver);
        } else {
            $this->Driver = $driver;
        }
        return $this;
    }
    /**
     * Get Parcel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Parcel|null
     */
    public function getParcel()
    {
        return isset($this->Parcel) ? $this->Parcel : null;
    }
    /**
     * Set Parcel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Parcel $parcel
     * @return \StructType\PrintDataInfo
     */
    public function setParcel(\StructType\Parcel $parcel = null)
    {
        if (is_null($parcel) || (is_array($parcel) && empty($parcel))) {
            unset($this->Parcel);
        } else {
            $this->Parcel = $parcel;
        }
        return $this;
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \StructType\PrintDataInfo
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get ParcelNumber value
     * @return int|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\PrintDataInfo
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ParcelNumberWithCheckdigit value
     * @return int|null
     */
    public function getParcelNumberWithCheckdigit()
    {
        return $this->ParcelNumberWithCheckdigit;
    }
    /**
     * Set ParcelNumberWithCheckdigit value
     * @param int $parcelNumberWithCheckdigit
     * @return \StructType\PrintDataInfo
     */
    public function setParcelNumberWithCheckdigit($parcelNumberWithCheckdigit = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumberWithCheckdigit) && !(is_int($parcelNumberWithCheckdigit) || ctype_digit($parcelNumberWithCheckdigit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumberWithCheckdigit, true), gettype($parcelNumberWithCheckdigit)), __LINE__);
        }
        $this->ParcelNumberWithCheckdigit = $parcelNumberWithCheckdigit;
        return $this;
    }
    /**
     * Get Sort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSort()
    {
        return isset($this->Sort) ? $this->Sort : null;
    }
    /**
     * Set Sort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sort
     * @return \StructType\PrintDataInfo
     */
    public function setSort($sort = null)
    {
        // validation for constraint: string
        if (!is_null($sort) && !is_string($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        if (is_null($sort) || (is_array($sort) && empty($sort))) {
            unset($this->Sort);
        } else {
            $this->Sort = $sort;
        }
        return $this;
    }
}
