<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parcel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Parcel
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The CODAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CODAmount;
    /**
     * The CODCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CODCurrency;
    /**
     * The CODReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CODReference;
    /**
     * The ClientNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ClientNumber;
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Content;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $DeliveryAddress;
    /**
     * The PickupAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $PickupAddress;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PickupDate;
    /**
     * The ServiceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfService
     */
    public $ServiceList;
    /**
     * Constructor method for Parcel
     * @uses Parcel::setCODAmount()
     * @uses Parcel::setCODCurrency()
     * @uses Parcel::setCODReference()
     * @uses Parcel::setClientNumber()
     * @uses Parcel::setClientReference()
     * @uses Parcel::setContent()
     * @uses Parcel::setCount()
     * @uses Parcel::setDeliveryAddress()
     * @uses Parcel::setPickupAddress()
     * @uses Parcel::setPickupDate()
     * @uses Parcel::setServiceList()
     * @param float $cODAmount
     * @param string $cODCurrency
     * @param string $cODReference
     * @param int $clientNumber
     * @param string $clientReference
     * @param string $content
     * @param int $count
     * @param \StructType\Address $deliveryAddress
     * @param \StructType\Address $pickupAddress
     * @param string $pickupDate
     * @param \ArrayType\ArrayOfService $serviceList
     */
    public function __construct($cODAmount = null, $cODCurrency = null, $cODReference = null, $clientNumber = null, $clientReference = null, $content = null, $count = null, \StructType\Address $deliveryAddress = null, \StructType\Address $pickupAddress = null, $pickupDate = null, \ArrayType\ArrayOfService $serviceList = null)
    {
        $this
            ->setCODAmount($cODAmount)
            ->setCODCurrency($cODCurrency)
            ->setCODReference($cODReference)
            ->setClientNumber($clientNumber)
            ->setClientReference($clientReference)
            ->setContent($content)
            ->setCount($count)
            ->setDeliveryAddress($deliveryAddress)
            ->setPickupAddress($pickupAddress)
            ->setPickupDate($pickupDate)
            ->setServiceList($serviceList);
    }
    /**
     * Get CODAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCODAmount()
    {
        return isset($this->CODAmount) ? $this->CODAmount : null;
    }
    /**
     * Set CODAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cODAmount
     * @return \StructType\Parcel
     */
    public function setCODAmount($cODAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cODAmount) && !(is_float($cODAmount) || is_numeric($cODAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cODAmount, true), gettype($cODAmount)), __LINE__);
        }
        if (is_null($cODAmount) || (is_array($cODAmount) && empty($cODAmount))) {
            unset($this->CODAmount);
        } else {
            $this->CODAmount = $cODAmount;
        }
        return $this;
    }
    /**
     * Get CODCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCODCurrency()
    {
        return isset($this->CODCurrency) ? $this->CODCurrency : null;
    }
    /**
     * Set CODCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cODCurrency
     * @return \StructType\Parcel
     */
    public function setCODCurrency($cODCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cODCurrency) && !is_string($cODCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODCurrency, true), gettype($cODCurrency)), __LINE__);
        }
        if (is_null($cODCurrency) || (is_array($cODCurrency) && empty($cODCurrency))) {
            unset($this->CODCurrency);
        } else {
            $this->CODCurrency = $cODCurrency;
        }
        return $this;
    }
    /**
     * Get CODReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCODReference()
    {
        return isset($this->CODReference) ? $this->CODReference : null;
    }
    /**
     * Set CODReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cODReference
     * @return \StructType\Parcel
     */
    public function setCODReference($cODReference = null)
    {
        // validation for constraint: string
        if (!is_null($cODReference) && !is_string($cODReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODReference, true), gettype($cODReference)), __LINE__);
        }
        if (is_null($cODReference) || (is_array($cODReference) && empty($cODReference))) {
            unset($this->CODReference);
        } else {
            $this->CODReference = $cODReference;
        }
        return $this;
    }
    /**
     * Get ClientNumber value
     * @return int|null
     */
    public function getClientNumber()
    {
        return $this->ClientNumber;
    }
    /**
     * Set ClientNumber value
     * @param int $clientNumber
     * @return \StructType\Parcel
     */
    public function setClientNumber($clientNumber = null)
    {
        // validation for constraint: int
        if (!is_null($clientNumber) && !(is_int($clientNumber) || ctype_digit($clientNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientNumber, true), gettype($clientNumber)), __LINE__);
        }
        $this->ClientNumber = $clientNumber;
        return $this;
    }
    /**
     * Get ClientReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReference()
    {
        return isset($this->ClientReference) ? $this->ClientReference : null;
    }
    /**
     * Set ClientReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReference
     * @return \StructType\Parcel
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        if (is_null($clientReference) || (is_array($clientReference) && empty($clientReference))) {
            unset($this->ClientReference);
        } else {
            $this->ClientReference = $clientReference;
        }
        return $this;
    }
    /**
     * Get Content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContent()
    {
        return isset($this->Content) ? $this->Content : null;
    }
    /**
     * Set Content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $content
     * @return \StructType\Parcel
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->Content);
        } else {
            $this->Content = $content;
        }
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Parcel
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->DeliveryAddress) ? $this->DeliveryAddress : null;
    }
    /**
     * Set DeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $deliveryAddress
     * @return \StructType\Parcel
     */
    public function setDeliveryAddress(\StructType\Address $deliveryAddress = null)
    {
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->DeliveryAddress);
        } else {
            $this->DeliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get PickupAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getPickupAddress()
    {
        return isset($this->PickupAddress) ? $this->PickupAddress : null;
    }
    /**
     * Set PickupAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $pickupAddress
     * @return \StructType\Parcel
     */
    public function setPickupAddress(\StructType\Address $pickupAddress = null)
    {
        if (is_null($pickupAddress) || (is_array($pickupAddress) && empty($pickupAddress))) {
            unset($this->PickupAddress);
        } else {
            $this->PickupAddress = $pickupAddress;
        }
        return $this;
    }
    /**
     * Get PickupDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPickupDate()
    {
        return isset($this->PickupDate) ? $this->PickupDate : null;
    }
    /**
     * Set PickupDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pickupDate
     * @return \StructType\Parcel
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        if (is_null($pickupDate) || (is_array($pickupDate) && empty($pickupDate))) {
            unset($this->PickupDate);
        } else {
            $this->PickupDate = $pickupDate;
        }
        return $this;
    }
    /**
     * Get ServiceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfService|null
     */
    public function getServiceList()
    {
        return isset($this->ServiceList) ? $this->ServiceList : null;
    }
    /**
     * Set ServiceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfService $serviceList
     * @return \StructType\Parcel
     */
    public function setServiceList(\ArrayType\ArrayOfService $serviceList = null)
    {
        if (is_null($serviceList) || (is_array($serviceList) && empty($serviceList))) {
            unset($this->ServiceList);
        } else {
            $this->ServiceList = $serviceList;
        }
        return $this;
    }
}
