<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelStatusesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetParcelStatusesRequest
 * @subpackage Structs
 */
class GetParcelStatusesRequest extends APIRequestBase
{
    /**
     * The LanguageIsoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageIsoCode;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelNumber;
    /**
     * The ReturnPOD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnPOD;
    /**
     * Constructor method for GetParcelStatusesRequest
     * @uses GetParcelStatusesRequest::setLanguageIsoCode()
     * @uses GetParcelStatusesRequest::setParcelNumber()
     * @uses GetParcelStatusesRequest::setReturnPOD()
     * @param string $languageIsoCode
     * @param int $parcelNumber
     * @param bool $returnPOD
     */
    public function __construct($languageIsoCode = null, $parcelNumber = null, $returnPOD = null)
    {
        $this
            ->setLanguageIsoCode($languageIsoCode)
            ->setParcelNumber($parcelNumber)
            ->setReturnPOD($returnPOD);
    }
    /**
     * Get LanguageIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageIsoCode()
    {
        return isset($this->LanguageIsoCode) ? $this->LanguageIsoCode : null;
    }
    /**
     * Set LanguageIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageIsoCode
     * @return \StructType\GetParcelStatusesRequest
     */
    public function setLanguageIsoCode($languageIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageIsoCode) && !is_string($languageIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageIsoCode, true), gettype($languageIsoCode)), __LINE__);
        }
        if (is_null($languageIsoCode) || (is_array($languageIsoCode) && empty($languageIsoCode))) {
            unset($this->LanguageIsoCode);
        } else {
            $this->LanguageIsoCode = $languageIsoCode;
        }
        return $this;
    }
    /**
     * Get ParcelNumber value
     * @return int|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\GetParcelStatusesRequest
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ReturnPOD value
     * @return bool|null
     */
    public function getReturnPOD()
    {
        return $this->ReturnPOD;
    }
    /**
     * Set ReturnPOD value
     * @param bool $returnPOD
     * @return \StructType\GetParcelStatusesRequest
     */
    public function setReturnPOD($returnPOD = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnPOD) && !is_bool($returnPOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnPOD, true), gettype($returnPOD)), __LINE__);
        }
        $this->ReturnPOD = $returnPOD;
        return $this;
    }
}
