<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ErrorInfo
 * @subpackage Structs
 */
class ErrorInfo extends AbstractStructBase
{
    /**
     * The ClientReferenceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ClientReferenceList;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The ParcelIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ParcelIdList;
    /**
     * Constructor method for ErrorInfo
     * @uses ErrorInfo::setClientReferenceList()
     * @uses ErrorInfo::setErrorCode()
     * @uses ErrorInfo::setErrorDescription()
     * @uses ErrorInfo::setParcelIdList()
     * @param \ArrayType\ArrayOfstring $clientReferenceList
     * @param int $errorCode
     * @param string $errorDescription
     * @param \ArrayType\ArrayOfint $parcelIdList
     */
    public function __construct(\ArrayType\ArrayOfstring $clientReferenceList = null, $errorCode = null, $errorDescription = null, \ArrayType\ArrayOfint $parcelIdList = null)
    {
        $this
            ->setClientReferenceList($clientReferenceList)
            ->setErrorCode($errorCode)
            ->setErrorDescription($errorDescription)
            ->setParcelIdList($parcelIdList);
    }
    /**
     * Get ClientReferenceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getClientReferenceList()
    {
        return isset($this->ClientReferenceList) ? $this->ClientReferenceList : null;
    }
    /**
     * Set ClientReferenceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $clientReferenceList
     * @return \StructType\ErrorInfo
     */
    public function setClientReferenceList(\ArrayType\ArrayOfstring $clientReferenceList = null)
    {
        if (is_null($clientReferenceList) || (is_array($clientReferenceList) && empty($clientReferenceList))) {
            unset($this->ClientReferenceList);
        } else {
            $this->ClientReferenceList = $clientReferenceList;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\ErrorInfo
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \StructType\ErrorInfo
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get ParcelIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getParcelIdList()
    {
        return isset($this->ParcelIdList) ? $this->ParcelIdList : null;
    }
    /**
     * Set ParcelIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $parcelIdList
     * @return \StructType\ErrorInfo
     */
    public function setParcelIdList(\ArrayType\ArrayOfint $parcelIdList = null)
    {
        if (is_null($parcelIdList) || (is_array($parcelIdList) && empty($parcelIdList))) {
            unset($this->ParcelIdList);
        } else {
            $this->ParcelIdList = $parcelIdList;
        }
        return $this;
    }
}
