<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The ContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactEmail;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactName;
    /**
     * The ContactPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactPhone;
    /**
     * The CountryIsoCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryIsoCode;
    /**
     * The HouseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HouseNumber;
    /**
     * The HouseNumberInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HouseNumberInfo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for Address
     * @uses Address::setCity()
     * @uses Address::setContactEmail()
     * @uses Address::setContactName()
     * @uses Address::setContactPhone()
     * @uses Address::setCountryIsoCode()
     * @uses Address::setHouseNumber()
     * @uses Address::setHouseNumberInfo()
     * @uses Address::setName()
     * @uses Address::setStreet()
     * @uses Address::setZipCode()
     * @param string $city
     * @param string $contactEmail
     * @param string $contactName
     * @param string $contactPhone
     * @param string $countryIsoCode
     * @param string $houseNumber
     * @param string $houseNumberInfo
     * @param string $name
     * @param string $street
     * @param string $zipCode
     */
    public function __construct($city = null, $contactEmail = null, $contactName = null, $contactPhone = null, $countryIsoCode = null, $houseNumber = null, $houseNumberInfo = null, $name = null, $street = null, $zipCode = null)
    {
        $this
            ->setCity($city)
            ->setContactEmail($contactEmail)
            ->setContactName($contactName)
            ->setContactPhone($contactPhone)
            ->setCountryIsoCode($countryIsoCode)
            ->setHouseNumber($houseNumber)
            ->setHouseNumberInfo($houseNumberInfo)
            ->setName($name)
            ->setStreet($street)
            ->setZipCode($zipCode);
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get ContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactEmail()
    {
        return isset($this->ContactEmail) ? $this->ContactEmail : null;
    }
    /**
     * Set ContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactEmail
     * @return \StructType\Address
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        if (is_null($contactEmail) || (is_array($contactEmail) && empty($contactEmail))) {
            unset($this->ContactEmail);
        } else {
            $this->ContactEmail = $contactEmail;
        }
        return $this;
    }
    /**
     * Get ContactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->ContactName) ? $this->ContactName : null;
    }
    /**
     * Set ContactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \StructType\Address
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->ContactName);
        } else {
            $this->ContactName = $contactName;
        }
        return $this;
    }
    /**
     * Get ContactPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPhone()
    {
        return isset($this->ContactPhone) ? $this->ContactPhone : null;
    }
    /**
     * Set ContactPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPhone
     * @return \StructType\Address
     */
    public function setContactPhone($contactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhone) && !is_string($contactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhone, true), gettype($contactPhone)), __LINE__);
        }
        if (is_null($contactPhone) || (is_array($contactPhone) && empty($contactPhone))) {
            unset($this->ContactPhone);
        } else {
            $this->ContactPhone = $contactPhone;
        }
        return $this;
    }
    /**
     * Get CountryIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryIsoCode()
    {
        return isset($this->CountryIsoCode) ? $this->CountryIsoCode : null;
    }
    /**
     * Set CountryIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryIsoCode
     * @return \StructType\Address
     */
    public function setCountryIsoCode($countryIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryIsoCode) && !is_string($countryIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIsoCode, true), gettype($countryIsoCode)), __LINE__);
        }
        if (is_null($countryIsoCode) || (is_array($countryIsoCode) && empty($countryIsoCode))) {
            unset($this->CountryIsoCode);
        } else {
            $this->CountryIsoCode = $countryIsoCode;
        }
        return $this;
    }
    /**
     * Get HouseNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHouseNumber()
    {
        return isset($this->HouseNumber) ? $this->HouseNumber : null;
    }
    /**
     * Set HouseNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $houseNumber
     * @return \StructType\Address
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        if (is_null($houseNumber) || (is_array($houseNumber) && empty($houseNumber))) {
            unset($this->HouseNumber);
        } else {
            $this->HouseNumber = $houseNumber;
        }
        return $this;
    }
    /**
     * Get HouseNumberInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHouseNumberInfo()
    {
        return isset($this->HouseNumberInfo) ? $this->HouseNumberInfo : null;
    }
    /**
     * Set HouseNumberInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $houseNumberInfo
     * @return \StructType\Address
     */
    public function setHouseNumberInfo($houseNumberInfo = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumberInfo) && !is_string($houseNumberInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumberInfo, true), gettype($houseNumberInfo)), __LINE__);
        }
        if (is_null($houseNumberInfo) || (is_array($houseNumberInfo) && empty($houseNumberInfo))) {
            unset($this->HouseNumberInfo);
        } else {
            $this->HouseNumberInfo = $houseNumberInfo;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Address
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
}
