<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParcelInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfParcelInfo
 * @subpackage Arrays
 */
class ArrayOfParcelInfo extends AbstractStructArrayBase
{
    /**
     * The ParcelInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelInfo[]
     */
    public $ParcelInfo;
    /**
     * Constructor method for ArrayOfParcelInfo
     * @uses ArrayOfParcelInfo::setParcelInfo()
     * @param \StructType\ParcelInfo[] $parcelInfo
     */
    public function __construct(array $parcelInfo = array())
    {
        $this
            ->setParcelInfo($parcelInfo);
    }
    /**
     * Get ParcelInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelInfo[]|null
     */
    public function getParcelInfo()
    {
        return isset($this->ParcelInfo) ? $this->ParcelInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelInfoForArrayConstraintsFromSetParcelInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfParcelInfoParcelInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfParcelInfoParcelInfoItem instanceof \StructType\ParcelInfo) {
                $invalidValues[] = is_object($arrayOfParcelInfoParcelInfoItem) ? get_class($arrayOfParcelInfoParcelInfoItem) : sprintf('%s(%s)', gettype($arrayOfParcelInfoParcelInfoItem), var_export($arrayOfParcelInfoParcelInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ParcelInfo property can only contain items of type \StructType\ParcelInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ParcelInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelInfo[] $parcelInfo
     * @return \ArrayType\ArrayOfParcelInfo
     */
    public function setParcelInfo(array $parcelInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelInfoArrayErrorMessage = self::validateParcelInfoForArrayConstraintsFromSetParcelInfo($parcelInfo))) {
            throw new \InvalidArgumentException($parcelInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($parcelInfo) || (is_array($parcelInfo) && empty($parcelInfo))) {
            unset($this->ParcelInfo);
        } else {
            $this->ParcelInfo = $parcelInfo;
        }
        return $this;
    }
    /**
     * Add item to ParcelInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelInfo $item
     * @return \ArrayType\ArrayOfParcelInfo
     */
    public function addToParcelInfo(\StructType\ParcelInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelInfo) {
            throw new \InvalidArgumentException(sprintf('The ParcelInfo property can only contain items of type \StructType\ParcelInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ParcelInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ParcelInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ParcelInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ParcelInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ParcelInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ParcelInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ParcelInfo
     */
    public function getAttributeName()
    {
        return 'ParcelInfo';
    }
}
