<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfErrorInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfErrorInfo
 * @subpackage Arrays
 */
class ArrayOfErrorInfo extends AbstractStructArrayBase
{
    /**
     * The ErrorInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInfo[]
     */
    public $ErrorInfo;
    /**
     * Constructor method for ArrayOfErrorInfo
     * @uses ArrayOfErrorInfo::setErrorInfo()
     * @param \StructType\ErrorInfo[] $errorInfo
     */
    public function __construct(array $errorInfo = array())
    {
        $this
            ->setErrorInfo($errorInfo);
    }
    /**
     * Get ErrorInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInfo[]|null
     */
    public function getErrorInfo()
    {
        return isset($this->ErrorInfo) ? $this->ErrorInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorInfoForArrayConstraintsFromSetErrorInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfErrorInfoErrorInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfErrorInfoErrorInfoItem instanceof \StructType\ErrorInfo) {
                $invalidValues[] = is_object($arrayOfErrorInfoErrorInfoItem) ? get_class($arrayOfErrorInfoErrorInfoItem) : sprintf('%s(%s)', gettype($arrayOfErrorInfoErrorInfoItem), var_export($arrayOfErrorInfoErrorInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ErrorInfo property can only contain items of type \StructType\ErrorInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ErrorInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo[] $errorInfo
     * @return \ArrayType\ArrayOfErrorInfo
     */
    public function setErrorInfo(array $errorInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($errorInfoArrayErrorMessage = self::validateErrorInfoForArrayConstraintsFromSetErrorInfo($errorInfo))) {
            throw new \InvalidArgumentException($errorInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($errorInfo) || (is_array($errorInfo) && empty($errorInfo))) {
            unset($this->ErrorInfo);
        } else {
            $this->ErrorInfo = $errorInfo;
        }
        return $this;
    }
    /**
     * Add item to ErrorInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorInfo $item
     * @return \ArrayType\ArrayOfErrorInfo
     */
    public function addToErrorInfo(\StructType\ErrorInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorInfo) {
            throw new \InvalidArgumentException(sprintf('The ErrorInfo property can only contain items of type \StructType\ErrorInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ErrorInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ErrorInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ErrorInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ErrorInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ErrorInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ErrorInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ErrorInfo
     */
    public function getAttributeName()
    {
        return 'ErrorInfo';
    }
}
