<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.test.mygls.hu/ParcelService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.test.mygls.hu/ParcelService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteLabels_20190201 operation/method
 */
if ($delete->DeleteLabels_20190201(new \StructType\DeleteLabels_20190201()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteLabels operation/method
 */
if ($delete->DeleteLabels(new \StructType\DeleteLabels()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetPrintData_20190201 operation/method
 */
if ($get->GetPrintData_20190201(new \StructType\GetPrintData_20190201()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPrintedLabels_20190201 operation/method
 */
if ($get->GetPrintedLabels_20190201(new \StructType\GetPrintedLabels_20190201()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPrintData operation/method
 */
if ($get->GetPrintData(new \StructType\GetPrintData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPrintedLabels operation/method
 */
if ($get->GetPrintedLabels(new \StructType\GetPrintedLabels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetParcelList operation/method
 */
if ($get->GetParcelList(new \StructType\GetParcelList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetParcelStatuses operation/method
 */
if ($get->GetParcelStatuses(new \StructType\GetParcelStatuses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \ServiceType\Prepare($options);
/**
 * Sample call for PrepareLabels_20190201 operation/method
 */
if ($prepare->PrepareLabels_20190201(new \StructType\PrepareLabels_20190201()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareLabels operation/method
 */
if ($prepare->PrepareLabels(new \StructType\PrepareLabels()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \ServiceType\_Print($options);
/**
 * Sample call for PrintLabels_20190201 operation/method
 */
if ($print->PrintLabels_20190201(new \StructType\PrintLabels_20190201()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for PrintLabels operation/method
 */
if ($print->PrintLabels(new \StructType\PrintLabels()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyCOD_20190201 operation/method
 */
if ($modify->ModifyCOD_20190201(new \StructType\ModifyCOD_20190201()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyCOD operation/method
 */
if ($modify->ModifyCOD(new \StructType\ModifyCOD()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
