<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceParameterStringInteger StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceParameterStringInteger
 * @subpackage Structs
 */
class ServiceParameterStringInteger extends AbstractStructBase
{
    /**
     * The IntegerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntegerValue;
    /**
     * The StringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringValue;
    /**
     * Constructor method for ServiceParameterStringInteger
     * @uses ServiceParameterStringInteger::setIntegerValue()
     * @uses ServiceParameterStringInteger::setStringValue()
     * @param int $integerValue
     * @param string $stringValue
     */
    public function __construct($integerValue = null, $stringValue = null)
    {
        $this
            ->setIntegerValue($integerValue)
            ->setStringValue($stringValue);
    }
    /**
     * Get IntegerValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntegerValue()
    {
        return isset($this->IntegerValue) ? $this->IntegerValue : null;
    }
    /**
     * Set IntegerValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $integerValue
     * @return \StructType\ServiceParameterStringInteger
     */
    public function setIntegerValue($integerValue = null)
    {
        // validation for constraint: int
        if (!is_null($integerValue) && !(is_int($integerValue) || ctype_digit($integerValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerValue, true), gettype($integerValue)), __LINE__);
        }
        if (is_null($integerValue) || (is_array($integerValue) && empty($integerValue))) {
            unset($this->IntegerValue);
        } else {
            $this->IntegerValue = $integerValue;
        }
        return $this;
    }
    /**
     * Get StringValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringValue()
    {
        return isset($this->StringValue) ? $this->StringValue : null;
    }
    /**
     * Set StringValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringValue
     * @return \StructType\ServiceParameterStringInteger
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        if (is_null($stringValue) || (is_array($stringValue) && empty($stringValue))) {
            unset($this->StringValue);
        } else {
            $this->StringValue = $stringValue;
        }
        return $this;
    }
}
