<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceParameterADR StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceParameterADR
 * @subpackage Structs
 */
class ServiceParameterADR extends AbstractStructBase
{
    /**
     * The AdrItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdrItemType;
    /**
     * The AmountUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmountUnit;
    /**
     * The InnerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InnerCount;
    /**
     * The PackSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackSize;
    /**
     * The UnNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UnNumber;
    /**
     * Constructor method for ServiceParameterADR
     * @uses ServiceParameterADR::setAdrItemType()
     * @uses ServiceParameterADR::setAmountUnit()
     * @uses ServiceParameterADR::setInnerCount()
     * @uses ServiceParameterADR::setPackSize()
     * @uses ServiceParameterADR::setUnNumber()
     * @param string $adrItemType
     * @param string $amountUnit
     * @param int $innerCount
     * @param int $packSize
     * @param int $unNumber
     */
    public function __construct($adrItemType = null, $amountUnit = null, $innerCount = null, $packSize = null, $unNumber = null)
    {
        $this
            ->setAdrItemType($adrItemType)
            ->setAmountUnit($amountUnit)
            ->setInnerCount($innerCount)
            ->setPackSize($packSize)
            ->setUnNumber($unNumber);
    }
    /**
     * Get AdrItemType value
     * @return string|null
     */
    public function getAdrItemType()
    {
        return $this->AdrItemType;
    }
    /**
     * Set AdrItemType value
     * @uses \EnumType\AdrItemType::valueIsValid()
     * @uses \EnumType\AdrItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adrItemType
     * @return \StructType\ServiceParameterADR
     */
    public function setAdrItemType($adrItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdrItemType::valueIsValid($adrItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdrItemType', is_array($adrItemType) ? implode(', ', $adrItemType) : var_export($adrItemType, true), implode(', ', \EnumType\AdrItemType::getValidValues())), __LINE__);
        }
        $this->AdrItemType = $adrItemType;
        return $this;
    }
    /**
     * Get AmountUnit value
     * @return string|null
     */
    public function getAmountUnit()
    {
        return $this->AmountUnit;
    }
    /**
     * Set AmountUnit value
     * @uses \EnumType\AmountUnit::valueIsValid()
     * @uses \EnumType\AmountUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountUnit
     * @return \StructType\ServiceParameterADR
     */
    public function setAmountUnit($amountUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountUnit::valueIsValid($amountUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AmountUnit', is_array($amountUnit) ? implode(', ', $amountUnit) : var_export($amountUnit, true), implode(', ', \EnumType\AmountUnit::getValidValues())), __LINE__);
        }
        $this->AmountUnit = $amountUnit;
        return $this;
    }
    /**
     * Get InnerCount value
     * @return int|null
     */
    public function getInnerCount()
    {
        return $this->InnerCount;
    }
    /**
     * Set InnerCount value
     * @param int $innerCount
     * @return \StructType\ServiceParameterADR
     */
    public function setInnerCount($innerCount = null)
    {
        // validation for constraint: int
        if (!is_null($innerCount) && !(is_int($innerCount) || ctype_digit($innerCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($innerCount, true), gettype($innerCount)), __LINE__);
        }
        $this->InnerCount = $innerCount;
        return $this;
    }
    /**
     * Get PackSize value
     * @return int|null
     */
    public function getPackSize()
    {
        return $this->PackSize;
    }
    /**
     * Set PackSize value
     * @param int $packSize
     * @return \StructType\ServiceParameterADR
     */
    public function setPackSize($packSize = null)
    {
        // validation for constraint: int
        if (!is_null($packSize) && !(is_int($packSize) || ctype_digit($packSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packSize, true), gettype($packSize)), __LINE__);
        }
        $this->PackSize = $packSize;
        return $this;
    }
    /**
     * Get UnNumber value
     * @return int|null
     */
    public function getUnNumber()
    {
        return $this->UnNumber;
    }
    /**
     * Set UnNumber value
     * @param int $unNumber
     * @return \StructType\ServiceParameterADR
     */
    public function setUnNumber($unNumber = null)
    {
        // validation for constraint: int
        if (!is_null($unNumber) && !(is_int($unNumber) || ctype_digit($unNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unNumber, true), gettype($unNumber)), __LINE__);
        }
        $this->UnNumber = $unNumber;
        return $this;
    }
}
