<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrintLabelsRequest
 * @subpackage Structs
 */
class PrintLabelsRequest extends APIRequestBase
{
    /**
     * The ParcelList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcel
     */
    public $ParcelList;
    /**
     * The PrintPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrintPosition;
    /**
     * The ShowPrintDialog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShowPrintDialog;
    /**
     * The TypeOfPrinter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeOfPrinter;
    /**
     * Constructor method for PrintLabelsRequest
     * @uses PrintLabelsRequest::setParcelList()
     * @uses PrintLabelsRequest::setPrintPosition()
     * @uses PrintLabelsRequest::setShowPrintDialog()
     * @uses PrintLabelsRequest::setTypeOfPrinter()
     * @param \ArrayType\ArrayOfParcel $parcelList
     * @param int $printPosition
     * @param bool $showPrintDialog
     * @param string $typeOfPrinter
     */
    public function __construct(\ArrayType\ArrayOfParcel $parcelList = null, $printPosition = null, $showPrintDialog = null, $typeOfPrinter = null)
    {
        $this
            ->setParcelList($parcelList)
            ->setPrintPosition($printPosition)
            ->setShowPrintDialog($showPrintDialog)
            ->setTypeOfPrinter($typeOfPrinter);
    }
    /**
     * Get ParcelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcel|null
     */
    public function getParcelList()
    {
        return isset($this->ParcelList) ? $this->ParcelList : null;
    }
    /**
     * Set ParcelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcel $parcelList
     * @return \StructType\PrintLabelsRequest
     */
    public function setParcelList(\ArrayType\ArrayOfParcel $parcelList = null)
    {
        if (is_null($parcelList) || (is_array($parcelList) && empty($parcelList))) {
            unset($this->ParcelList);
        } else {
            $this->ParcelList = $parcelList;
        }
        return $this;
    }
    /**
     * Get PrintPosition value
     * @return int|null
     */
    public function getPrintPosition()
    {
        return $this->PrintPosition;
    }
    /**
     * Set PrintPosition value
     * @param int $printPosition
     * @return \StructType\PrintLabelsRequest
     */
    public function setPrintPosition($printPosition = null)
    {
        // validation for constraint: int
        if (!is_null($printPosition) && !(is_int($printPosition) || ctype_digit($printPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printPosition, true), gettype($printPosition)), __LINE__);
        }
        $this->PrintPosition = $printPosition;
        return $this;
    }
    /**
     * Get ShowPrintDialog value
     * @return bool|null
     */
    public function getShowPrintDialog()
    {
        return $this->ShowPrintDialog;
    }
    /**
     * Set ShowPrintDialog value
     * @param bool $showPrintDialog
     * @return \StructType\PrintLabelsRequest
     */
    public function setShowPrintDialog($showPrintDialog = null)
    {
        // validation for constraint: boolean
        if (!is_null($showPrintDialog) && !is_bool($showPrintDialog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showPrintDialog, true), gettype($showPrintDialog)), __LINE__);
        }
        $this->ShowPrintDialog = $showPrintDialog;
        return $this;
    }
    /**
     * Get TypeOfPrinter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeOfPrinter()
    {
        return isset($this->TypeOfPrinter) ? $this->TypeOfPrinter : null;
    }
    /**
     * Set TypeOfPrinter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeOfPrinter
     * @return \StructType\PrintLabelsRequest
     */
    public function setTypeOfPrinter($typeOfPrinter = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfPrinter) && !is_string($typeOfPrinter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfPrinter, true), gettype($typeOfPrinter)), __LINE__);
        }
        if (is_null($typeOfPrinter) || (is_array($typeOfPrinter) && empty($typeOfPrinter))) {
            unset($this->TypeOfPrinter);
        } else {
            $this->TypeOfPrinter = $typeOfPrinter;
        }
        return $this;
    }
}
