<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelStatus
 * @subpackage Structs
 */
class ParcelStatus extends AbstractStructBase
{
    /**
     * The DepotCity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepotCity;
    /**
     * The DepotNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepotNumber;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusDate;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDescription;
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusInfo;
    /**
     * Constructor method for ParcelStatus
     * @uses ParcelStatus::setDepotCity()
     * @uses ParcelStatus::setDepotNumber()
     * @uses ParcelStatus::setStatusCode()
     * @uses ParcelStatus::setStatusDate()
     * @uses ParcelStatus::setStatusDescription()
     * @uses ParcelStatus::setStatusInfo()
     * @param string $depotCity
     * @param string $depotNumber
     * @param string $statusCode
     * @param string $statusDate
     * @param string $statusDescription
     * @param string $statusInfo
     */
    public function __construct($depotCity = null, $depotNumber = null, $statusCode = null, $statusDate = null, $statusDescription = null, $statusInfo = null)
    {
        $this
            ->setDepotCity($depotCity)
            ->setDepotNumber($depotNumber)
            ->setStatusCode($statusCode)
            ->setStatusDate($statusDate)
            ->setStatusDescription($statusDescription)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get DepotCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepotCity()
    {
        return isset($this->DepotCity) ? $this->DepotCity : null;
    }
    /**
     * Set DepotCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depotCity
     * @return \StructType\ParcelStatus
     */
    public function setDepotCity($depotCity = null)
    {
        // validation for constraint: string
        if (!is_null($depotCity) && !is_string($depotCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depotCity, true), gettype($depotCity)), __LINE__);
        }
        if (is_null($depotCity) || (is_array($depotCity) && empty($depotCity))) {
            unset($this->DepotCity);
        } else {
            $this->DepotCity = $depotCity;
        }
        return $this;
    }
    /**
     * Get DepotNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepotNumber()
    {
        return isset($this->DepotNumber) ? $this->DepotNumber : null;
    }
    /**
     * Set DepotNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depotNumber
     * @return \StructType\ParcelStatus
     */
    public function setDepotNumber($depotNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depotNumber) && !is_string($depotNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depotNumber, true), gettype($depotNumber)), __LINE__);
        }
        if (is_null($depotNumber) || (is_array($depotNumber) && empty($depotNumber))) {
            unset($this->DepotNumber);
        } else {
            $this->DepotNumber = $depotNumber;
        }
        return $this;
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \StructType\ParcelStatus
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string|null
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \StructType\ParcelStatus
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get StatusDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDescription()
    {
        return isset($this->StatusDescription) ? $this->StatusDescription : null;
    }
    /**
     * Set StatusDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDescription
     * @return \StructType\ParcelStatus
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        if (is_null($statusDescription) || (is_array($statusDescription) && empty($statusDescription))) {
            unset($this->StatusDescription);
        } else {
            $this->StatusDescription = $statusDescription;
        }
        return $this;
    }
    /**
     * Get StatusInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusInfo()
    {
        return isset($this->StatusInfo) ? $this->StatusInfo : null;
    }
    /**
     * Set StatusInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusInfo
     * @return \StructType\ParcelStatus
     */
    public function setStatusInfo($statusInfo = null)
    {
        // validation for constraint: string
        if (!is_null($statusInfo) && !is_string($statusInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusInfo, true), gettype($statusInfo)), __LINE__);
        }
        if (is_null($statusInfo) || (is_array($statusInfo) && empty($statusInfo))) {
            unset($this->StatusInfo);
        } else {
            $this->StatusInfo = $statusInfo;
        }
        return $this;
    }
}
