<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelInfo
 * @subpackage Structs
 */
class ParcelInfo extends AbstractStructBase
{
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * Constructor method for ParcelInfo
     * @uses ParcelInfo::setClientReference()
     * @uses ParcelInfo::setParcelId()
     * @param string $clientReference
     * @param int $parcelId
     */
    public function __construct($clientReference = null, $parcelId = null)
    {
        $this
            ->setClientReference($clientReference)
            ->setParcelId($parcelId);
    }
    /**
     * Get ClientReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReference()
    {
        return isset($this->ClientReference) ? $this->ClientReference : null;
    }
    /**
     * Set ClientReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReference
     * @return \StructType\ParcelInfo
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        if (is_null($clientReference) || (is_array($clientReference) && empty($clientReference))) {
            unset($this->ClientReference);
        } else {
            $this->ClientReference = $clientReference;
        }
        return $this;
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \StructType\ParcelInfo
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->ParcelId = $parcelId;
        return $this;
    }
}
