<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyCODRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyCODRequest
 * @subpackage Structs
 */
class ModifyCODRequest extends APIRequestBase
{
    /**
     * The CODAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CODAmount;
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParcelId;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParcelNumber;
    /**
     * Constructor method for ModifyCODRequest
     * @uses ModifyCODRequest::setCODAmount()
     * @uses ModifyCODRequest::setParcelId()
     * @uses ModifyCODRequest::setParcelNumber()
     * @param float $cODAmount
     * @param int $parcelId
     * @param int $parcelNumber
     */
    public function __construct($cODAmount = null, $parcelId = null, $parcelNumber = null)
    {
        $this
            ->setCODAmount($cODAmount)
            ->setParcelId($parcelId)
            ->setParcelNumber($parcelNumber);
    }
    /**
     * Get CODAmount value
     * @return float|null
     */
    public function getCODAmount()
    {
        return $this->CODAmount;
    }
    /**
     * Set CODAmount value
     * @param float $cODAmount
     * @return \StructType\ModifyCODRequest
     */
    public function setCODAmount($cODAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cODAmount) && !(is_float($cODAmount) || is_numeric($cODAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cODAmount, true), gettype($cODAmount)), __LINE__);
        }
        $this->CODAmount = $cODAmount;
        return $this;
    }
    /**
     * Get ParcelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParcelId()
    {
        return isset($this->ParcelId) ? $this->ParcelId : null;
    }
    /**
     * Set ParcelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parcelId
     * @return \StructType\ModifyCODRequest
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        if (is_null($parcelId) || (is_array($parcelId) && empty($parcelId))) {
            unset($this->ParcelId);
        } else {
            $this->ParcelId = $parcelId;
        }
        return $this;
    }
    /**
     * Get ParcelNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParcelNumber()
    {
        return isset($this->ParcelNumber) ? $this->ParcelNumber : null;
    }
    /**
     * Set ParcelNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parcelNumber
     * @return \StructType\ModifyCODRequest
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        if (is_null($parcelNumber) || (is_array($parcelNumber) && empty($parcelNumber))) {
            unset($this->ParcelNumber);
        } else {
            $this->ParcelNumber = $parcelNumber;
        }
        return $this;
    }
}
