<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPrintedLabelsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPrintedLabelsRequest
 * @subpackage Structs
 */
class GetPrintedLabelsRequest extends APIRequestBase
{
    /**
     * The ParcelIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ParcelIdList;
    /**
     * The PrintPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrintPosition;
    /**
     * The ShowPrintDialog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShowPrintDialog;
    /**
     * The TypeOfPrinter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeOfPrinter;
    /**
     * Constructor method for GetPrintedLabelsRequest
     * @uses GetPrintedLabelsRequest::setParcelIdList()
     * @uses GetPrintedLabelsRequest::setPrintPosition()
     * @uses GetPrintedLabelsRequest::setShowPrintDialog()
     * @uses GetPrintedLabelsRequest::setTypeOfPrinter()
     * @param \ArrayType\ArrayOfint $parcelIdList
     * @param int $printPosition
     * @param bool $showPrintDialog
     * @param string $typeOfPrinter
     */
    public function __construct(\ArrayType\ArrayOfint $parcelIdList = null, $printPosition = null, $showPrintDialog = null, $typeOfPrinter = null)
    {
        $this
            ->setParcelIdList($parcelIdList)
            ->setPrintPosition($printPosition)
            ->setShowPrintDialog($showPrintDialog)
            ->setTypeOfPrinter($typeOfPrinter);
    }
    /**
     * Get ParcelIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getParcelIdList()
    {
        return isset($this->ParcelIdList) ? $this->ParcelIdList : null;
    }
    /**
     * Set ParcelIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $parcelIdList
     * @return \StructType\GetPrintedLabelsRequest
     */
    public function setParcelIdList(\ArrayType\ArrayOfint $parcelIdList = null)
    {
        if (is_null($parcelIdList) || (is_array($parcelIdList) && empty($parcelIdList))) {
            unset($this->ParcelIdList);
        } else {
            $this->ParcelIdList = $parcelIdList;
        }
        return $this;
    }
    /**
     * Get PrintPosition value
     * @return int|null
     */
    public function getPrintPosition()
    {
        return $this->PrintPosition;
    }
    /**
     * Set PrintPosition value
     * @param int $printPosition
     * @return \StructType\GetPrintedLabelsRequest
     */
    public function setPrintPosition($printPosition = null)
    {
        // validation for constraint: int
        if (!is_null($printPosition) && !(is_int($printPosition) || ctype_digit($printPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printPosition, true), gettype($printPosition)), __LINE__);
        }
        $this->PrintPosition = $printPosition;
        return $this;
    }
    /**
     * Get ShowPrintDialog value
     * @return bool|null
     */
    public function getShowPrintDialog()
    {
        return $this->ShowPrintDialog;
    }
    /**
     * Set ShowPrintDialog value
     * @param bool $showPrintDialog
     * @return \StructType\GetPrintedLabelsRequest
     */
    public function setShowPrintDialog($showPrintDialog = null)
    {
        // validation for constraint: boolean
        if (!is_null($showPrintDialog) && !is_bool($showPrintDialog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showPrintDialog, true), gettype($showPrintDialog)), __LINE__);
        }
        $this->ShowPrintDialog = $showPrintDialog;
        return $this;
    }
    /**
     * Get TypeOfPrinter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeOfPrinter()
    {
        return isset($this->TypeOfPrinter) ? $this->TypeOfPrinter : null;
    }
    /**
     * Set TypeOfPrinter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeOfPrinter
     * @return \StructType\GetPrintedLabelsRequest
     */
    public function setTypeOfPrinter($typeOfPrinter = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfPrinter) && !is_string($typeOfPrinter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeOfPrinter, true), gettype($typeOfPrinter)), __LINE__);
        }
        if (is_null($typeOfPrinter) || (is_array($typeOfPrinter) && empty($typeOfPrinter))) {
            unset($this->TypeOfPrinter);
        } else {
            $this->TypeOfPrinter = $typeOfPrinter;
        }
        return $this;
    }
}
