<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPrintDataRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPrintDataRequest
 * @subpackage Structs
 */
class GetPrintDataRequest extends APIRequestBase
{
    /**
     * The ParcelIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ParcelIdList;
    /**
     * The ParcelList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcel
     */
    public $ParcelList;
    /**
     * Constructor method for GetPrintDataRequest
     * @uses GetPrintDataRequest::setParcelIdList()
     * @uses GetPrintDataRequest::setParcelList()
     * @param \ArrayType\ArrayOfint $parcelIdList
     * @param \ArrayType\ArrayOfParcel $parcelList
     */
    public function __construct(\ArrayType\ArrayOfint $parcelIdList = null, \ArrayType\ArrayOfParcel $parcelList = null)
    {
        $this
            ->setParcelIdList($parcelIdList)
            ->setParcelList($parcelList);
    }
    /**
     * Get ParcelIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getParcelIdList()
    {
        return isset($this->ParcelIdList) ? $this->ParcelIdList : null;
    }
    /**
     * Set ParcelIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $parcelIdList
     * @return \StructType\GetPrintDataRequest
     */
    public function setParcelIdList(\ArrayType\ArrayOfint $parcelIdList = null)
    {
        if (is_null($parcelIdList) || (is_array($parcelIdList) && empty($parcelIdList))) {
            unset($this->ParcelIdList);
        } else {
            $this->ParcelIdList = $parcelIdList;
        }
        return $this;
    }
    /**
     * Get ParcelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcel|null
     */
    public function getParcelList()
    {
        return isset($this->ParcelList) ? $this->ParcelList : null;
    }
    /**
     * Set ParcelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcel $parcelList
     * @return \StructType\GetPrintDataRequest
     */
    public function setParcelList(\ArrayType\ArrayOfParcel $parcelList = null)
    {
        if (is_null($parcelList) || (is_array($parcelList) && empty($parcelList))) {
            unset($this->ParcelList);
        } else {
            $this->ParcelList = $parcelList;
        }
        return $this;
    }
}
