<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetParcelStatusResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetParcelStatusResponse
 * @subpackage Structs
 */
class GetParcelStatusResponse extends AbstractStructBase
{
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientReference;
    /**
     * The DeliveryCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryCountryCode;
    /**
     * The DeliveryZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryZipCode;
    /**
     * The GetParcelStatusErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfErrorInfo
     */
    public $GetParcelStatusErrors;
    /**
     * The POD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $POD;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelNumber;
    /**
     * The ParcelStatusList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelStatus
     */
    public $ParcelStatusList;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Weight;
    /**
     * Constructor method for GetParcelStatusResponse
     * @uses GetParcelStatusResponse::setClientReference()
     * @uses GetParcelStatusResponse::setDeliveryCountryCode()
     * @uses GetParcelStatusResponse::setDeliveryZipCode()
     * @uses GetParcelStatusResponse::setGetParcelStatusErrors()
     * @uses GetParcelStatusResponse::setPOD()
     * @uses GetParcelStatusResponse::setParcelNumber()
     * @uses GetParcelStatusResponse::setParcelStatusList()
     * @uses GetParcelStatusResponse::setWeight()
     * @param string $clientReference
     * @param string $deliveryCountryCode
     * @param string $deliveryZipCode
     * @param \ArrayType\ArrayOfErrorInfo $getParcelStatusErrors
     * @param string $pOD
     * @param int $parcelNumber
     * @param \ArrayType\ArrayOfParcelStatus $parcelStatusList
     * @param float $weight
     */
    public function __construct($clientReference = null, $deliveryCountryCode = null, $deliveryZipCode = null, \ArrayType\ArrayOfErrorInfo $getParcelStatusErrors = null, $pOD = null, $parcelNumber = null, \ArrayType\ArrayOfParcelStatus $parcelStatusList = null, $weight = null)
    {
        $this
            ->setClientReference($clientReference)
            ->setDeliveryCountryCode($deliveryCountryCode)
            ->setDeliveryZipCode($deliveryZipCode)
            ->setGetParcelStatusErrors($getParcelStatusErrors)
            ->setPOD($pOD)
            ->setParcelNumber($parcelNumber)
            ->setParcelStatusList($parcelStatusList)
            ->setWeight($weight);
    }
    /**
     * Get ClientReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientReference()
    {
        return isset($this->ClientReference) ? $this->ClientReference : null;
    }
    /**
     * Set ClientReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientReference
     * @return \StructType\GetParcelStatusResponse
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        if (is_null($clientReference) || (is_array($clientReference) && empty($clientReference))) {
            unset($this->ClientReference);
        } else {
            $this->ClientReference = $clientReference;
        }
        return $this;
    }
    /**
     * Get DeliveryCountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryCountryCode()
    {
        return isset($this->DeliveryCountryCode) ? $this->DeliveryCountryCode : null;
    }
    /**
     * Set DeliveryCountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryCountryCode
     * @return \StructType\GetParcelStatusResponse
     */
    public function setDeliveryCountryCode($deliveryCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCountryCode) && !is_string($deliveryCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCountryCode, true), gettype($deliveryCountryCode)), __LINE__);
        }
        if (is_null($deliveryCountryCode) || (is_array($deliveryCountryCode) && empty($deliveryCountryCode))) {
            unset($this->DeliveryCountryCode);
        } else {
            $this->DeliveryCountryCode = $deliveryCountryCode;
        }
        return $this;
    }
    /**
     * Get DeliveryZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryZipCode()
    {
        return isset($this->DeliveryZipCode) ? $this->DeliveryZipCode : null;
    }
    /**
     * Set DeliveryZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryZipCode
     * @return \StructType\GetParcelStatusResponse
     */
    public function setDeliveryZipCode($deliveryZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryZipCode) && !is_string($deliveryZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryZipCode, true), gettype($deliveryZipCode)), __LINE__);
        }
        if (is_null($deliveryZipCode) || (is_array($deliveryZipCode) && empty($deliveryZipCode))) {
            unset($this->DeliveryZipCode);
        } else {
            $this->DeliveryZipCode = $deliveryZipCode;
        }
        return $this;
    }
    /**
     * Get GetParcelStatusErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfErrorInfo|null
     */
    public function getGetParcelStatusErrors()
    {
        return isset($this->GetParcelStatusErrors) ? $this->GetParcelStatusErrors : null;
    }
    /**
     * Set GetParcelStatusErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfErrorInfo $getParcelStatusErrors
     * @return \StructType\GetParcelStatusResponse
     */
    public function setGetParcelStatusErrors(\ArrayType\ArrayOfErrorInfo $getParcelStatusErrors = null)
    {
        if (is_null($getParcelStatusErrors) || (is_array($getParcelStatusErrors) && empty($getParcelStatusErrors))) {
            unset($this->GetParcelStatusErrors);
        } else {
            $this->GetParcelStatusErrors = $getParcelStatusErrors;
        }
        return $this;
    }
    /**
     * Get POD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPOD()
    {
        return isset($this->POD) ? $this->POD : null;
    }
    /**
     * Set POD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pOD
     * @return \StructType\GetParcelStatusResponse
     */
    public function setPOD($pOD = null)
    {
        // validation for constraint: string
        if (!is_null($pOD) && !is_string($pOD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOD, true), gettype($pOD)), __LINE__);
        }
        if (is_null($pOD) || (is_array($pOD) && empty($pOD))) {
            unset($this->POD);
        } else {
            $this->POD = $pOD;
        }
        return $this;
    }
    /**
     * Get ParcelNumber value
     * @return int|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\GetParcelStatusResponse
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ParcelStatusList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelStatus|null
     */
    public function getParcelStatusList()
    {
        return isset($this->ParcelStatusList) ? $this->ParcelStatusList : null;
    }
    /**
     * Set ParcelStatusList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelStatus $parcelStatusList
     * @return \StructType\GetParcelStatusResponse
     */
    public function setParcelStatusList(\ArrayType\ArrayOfParcelStatus $parcelStatusList = null)
    {
        if (is_null($parcelStatusList) || (is_array($parcelStatusList) && empty($parcelStatusList))) {
            unset($this->ParcelStatusList);
        } else {
            $this->ParcelStatusList = $parcelStatusList;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $weight
     * @return \StructType\GetParcelStatusResponse
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
}
