<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:APIRequestBase
 * @subpackage Structs
 */
class APIRequestBase extends AbstractStructBase
{
    /**
     * The ClientNumberList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ClientNumberList;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for APIRequestBase
     * @uses APIRequestBase::setClientNumberList()
     * @uses APIRequestBase::setPassword()
     * @uses APIRequestBase::setUsername()
     * @param \ArrayType\ArrayOfint $clientNumberList
     * @param string $password
     * @param string $username
     */
    public function __construct(\ArrayType\ArrayOfint $clientNumberList = null, $password = null, $username = null)
    {
        $this
            ->setClientNumberList($clientNumberList)
            ->setPassword($password)
            ->setUsername($username);
    }
    /**
     * Get ClientNumberList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getClientNumberList()
    {
        return isset($this->ClientNumberList) ? $this->ClientNumberList : null;
    }
    /**
     * Set ClientNumberList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $clientNumberList
     * @return \StructType\APIRequestBase
     */
    public function setClientNumberList(\ArrayType\ArrayOfint $clientNumberList = null)
    {
        if (is_null($clientNumberList) || (is_array($clientNumberList) && empty($clientNumberList))) {
            unset($this->ClientNumberList);
        } else {
            $this->ClientNumberList = $clientNumberList;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\APIRequestBase
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\APIRequestBase
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
}
