<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.crcind.com/csp/samples/SOAP.Demo.CLS?WSDL=1',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.crcind.com/csp/samples/SOAP.Demo.CLS?WSDL=1',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddInteger operation/method
 */
if ($add->AddInteger(new \StructType\AddInteger()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Divide ServiceType
 */
$divide = new \ServiceType\Divide($options);
/**
 * Sample call for DivideInteger operation/method
 */
if ($divide->DivideInteger(new \StructType\DivideInteger()) !== false) {
    print_r($divide->getResult());
} else {
    print_r($divide->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for FindPerson operation/method
 */
if ($find->FindPerson(new \StructType\FindPerson()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetByName operation/method
 */
if ($get->GetByName(new \StructType\GetByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDataSetByName operation/method
 */
if ($get->GetDataSetByName(new \StructType\GetDataSetByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetListByName operation/method
 */
if ($get->GetListByName(new \StructType\GetListByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \ServiceType\Lookup($options);
/**
 * Sample call for LookupCity operation/method
 */
if ($lookup->LookupCity(new \StructType\LookupCity()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Mission ServiceType
 */
$mission = new \ServiceType\Mission($options);
/**
 * Sample call for Mission operation/method
 */
if ($mission->Mission(new \StructType\Mission()) !== false) {
    print_r($mission->getResult());
} else {
    print_r($mission->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \ServiceType\Query($options);
/**
 * Sample call for QueryByName operation/method
 */
if ($query->QueryByName(new \StructType\QueryByName()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
