<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * @subpackage Structs
 */
class Person extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The SSN
     * @var string
     */
    public $SSN;
    /**
     * The DOB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DOB;
    /**
     * The Home
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Home;
    /**
     * The Office
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Office;
    /**
     * The Spouse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $Spouse;
    /**
     * The FavoriteColors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFavoriteColorsItemString
     */
    public $FavoriteColors;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Age;
    /**
     * Constructor method for Person
     * @uses Person::setName()
     * @uses Person::setSSN()
     * @uses Person::setDOB()
     * @uses Person::setHome()
     * @uses Person::setOffice()
     * @uses Person::setSpouse()
     * @uses Person::setFavoriteColors()
     * @uses Person::setAge()
     * @param string $name
     * @param string $sSN
     * @param string $dOB
     * @param \StructType\Address $home
     * @param \StructType\Address $office
     * @param \StructType\Person $spouse
     * @param \ArrayType\ArrayOfFavoriteColorsItemString $favoriteColors
     * @param int $age
     */
    public function __construct($name = null, $sSN = null, $dOB = null, \StructType\Address $home = null, \StructType\Address $office = null, \StructType\Person $spouse = null, \ArrayType\ArrayOfFavoriteColorsItemString $favoriteColors = null, $age = null)
    {
        $this
            ->setName($name)
            ->setSSN($sSN)
            ->setDOB($dOB)
            ->setHome($home)
            ->setOffice($office)
            ->setSpouse($spouse)
            ->setFavoriteColors($favoriteColors)
            ->setAge($age);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Person
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SSN value
     * @return string|null
     */
    public function getSSN()
    {
        return $this->SSN;
    }
    /**
     * Set SSN value
     * @param string $sSN
     * @return \StructType\Person
     */
    public function setSSN($sSN = null)
    {
        // validation for constraint: string
        if (!is_null($sSN) && !is_string($sSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSN, true), gettype($sSN)), __LINE__);
        }
        $this->SSN = $sSN;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\Person
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Home value
     * @return \StructType\Address|null
     */
    public function getHome()
    {
        return $this->Home;
    }
    /**
     * Set Home value
     * @param \StructType\Address $home
     * @return \StructType\Person
     */
    public function setHome(\StructType\Address $home = null)
    {
        $this->Home = $home;
        return $this;
    }
    /**
     * Get Office value
     * @return \StructType\Address|null
     */
    public function getOffice()
    {
        return $this->Office;
    }
    /**
     * Set Office value
     * @param \StructType\Address $office
     * @return \StructType\Person
     */
    public function setOffice(\StructType\Address $office = null)
    {
        $this->Office = $office;
        return $this;
    }
    /**
     * Get Spouse value
     * @return \StructType\Person|null
     */
    public function getSpouse()
    {
        return $this->Spouse;
    }
    /**
     * Set Spouse value
     * @param \StructType\Person $spouse
     * @return \StructType\Person
     */
    public function setSpouse(\StructType\Person $spouse = null)
    {
        $this->Spouse = $spouse;
        return $this;
    }
    /**
     * Get FavoriteColors value
     * @return \ArrayType\ArrayOfFavoriteColorsItemString|null
     */
    public function getFavoriteColors()
    {
        return $this->FavoriteColors;
    }
    /**
     * Set FavoriteColors value
     * @param \ArrayType\ArrayOfFavoriteColorsItemString $favoriteColors
     * @return \StructType\Person
     */
    public function setFavoriteColors(\ArrayType\ArrayOfFavoriteColorsItemString $favoriteColors = null)
    {
        $this->FavoriteColors = $favoriteColors;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\Person
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
}
