<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee StructType
 * @subpackage Structs
 */
class Employee extends Person
{
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Salary
     * Meta information extracted from the WSDL
     * - base: s:long
     * - maxInclusive: 100000
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $Salary;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Picture;
    /**
     * Constructor method for Employee
     * @uses Employee::setTitle()
     * @uses Employee::setSalary()
     * @uses Employee::setNotes()
     * @uses Employee::setPicture()
     * @param string $title
     * @param int $salary
     * @param string $notes
     * @param string $picture
     */
    public function __construct($title = null, $salary = null, $notes = null, $picture = null)
    {
        $this
            ->setTitle($title)
            ->setSalary($salary)
            ->setNotes($notes)
            ->setPicture($picture);
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Employee
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($title) && mb_strlen($title) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Salary value
     * @return int|null
     */
    public function getSalary()
    {
        return $this->Salary;
    }
    /**
     * Set Salary value
     * @param int $salary
     * @return \StructType\Employee
     */
    public function setSalary($salary = null)
    {
        // validation for constraint: int
        if (!is_null($salary) && !(is_int($salary) || ctype_digit($salary))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salary, true), gettype($salary)), __LINE__);
        }
        // validation for constraint: maxInclusive(100000)
        if (!is_null($salary) && $salary > 100000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100000', var_export($salary, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($salary) && $salary < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($salary, true)), __LINE__);
        }
        $this->Salary = $salary;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\Employee
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Picture value
     * @return string|null
     */
    public function getPicture()
    {
        return $this->Picture;
    }
    /**
     * Set Picture value
     * @param string $picture
     * @return \StructType\Employee
     */
    public function setPicture($picture = null)
    {
        // validation for constraint: string
        if (!is_null($picture) && !is_string($picture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($picture, true), gettype($picture)), __LINE__);
        }
        $this->Picture = $picture;
        return $this;
    }
}
