<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ByNameDataSet StructType
 * Meta information extracted from the WSDL
 * - IsDataSet: true
 * @subpackage Structs
 */
class ByNameDataSet extends AbstractStructBase
{
    /**
     * The ByName
     * Meta information extracted from the WSDL
     * - choice: ByName
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \StructType\ByName
     */
    public $ByName;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ByNameDataSet
     * @uses ByNameDataSet::setByName()
     * @uses ByNameDataSet::setAny()
     * @param \StructType\ByName $byName
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\ByName $byName = null, \DOMDocument $any = null)
    {
        $this
            ->setByName($byName)
            ->setAny($any);
    }
    /**
     * Get ByName value
     * @return \StructType\ByName|null
     */
    public function getByName()
    {
        return isset($this->ByName) ? $this->ByName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setByName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setByName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateByNameForChoiceConstraintsFromSetByName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ByName can\'t be set as the property %s is already set. Only one property must be set among these properties: ByName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ByName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ByName $byName
     * @return \StructType\ByNameDataSet
     */
    public function setByName(\StructType\ByName $byName = null)
    {
        // validation for constraint: choice(ByName)
        if ('' !== ($byNameChoiceErrorMessage = self::validateByNameForChoiceConstraintsFromSetByName($byName))) {
            throw new \InvalidArgumentException($byNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($byName) || (is_array($byName) && empty($byName))) {
            unset($this->ByName);
        } else {
            $this->ByName = $byName;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ByNameDataSet
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
