<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lookup ServiceType
 * @subpackage Services
 */
class Lookup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LookupCity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LookupCity $parameters
     * @return \StructType\LookupCityResponse|bool
     */
    public function LookupCity(\StructType\LookupCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LookupCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LookupCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
