<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetByName $parameters
     * @return \StructType\GetByNameResponse|bool
     */
    public function GetByName(\StructType\GetByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataSetByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataSetByName $parameters
     * @return \StructType\GetDataSetByNameResponse|bool
     */
    public function GetDataSetByName(\StructType\GetDataSetByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataSetByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListByName $parameters
     * @return \StructType\GetListByNameResponse|bool
     */
    public function GetListByName(\StructType\GetListByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetByNameResponse|\StructType\GetDataSetByNameResponse|\StructType\GetListByNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
