<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Divide ServiceType
 * @subpackage Services
 */
class Divide extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DivideInteger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DivideInteger $parameters
     * @return \StructType\DivideIntegerResponse|bool
     */
    public function DivideInteger(\StructType\DivideInteger $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DivideInteger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DivideIntegerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
