<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupCity StructType
 * @subpackage Structs
 */
class LookupCity extends AbstractStructBase
{
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * Constructor method for LookupCity
     * @uses LookupCity::setZip()
     * @param string $zip
     */
    public function __construct($zip = null)
    {
        $this
            ->setZip($zip);
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\LookupCity
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
}
