<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ByName StructType
 * @subpackage Structs
 */
class ByName extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DOB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DOB;
    /**
     * The SSN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SSN;
    /**
     * Constructor method for ByName
     * @uses ByName::setID()
     * @uses ByName::setName()
     * @uses ByName::setDOB()
     * @uses ByName::setSSN()
     * @param int $iD
     * @param string $name
     * @param string $dOB
     * @param string $sSN
     */
    public function __construct($iD = null, $name = null, $dOB = null, $sSN = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setDOB($dOB)
            ->setSSN($sSN);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ByName
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ByName
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\ByName
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get SSN value
     * @return string|null
     */
    public function getSSN()
    {
        return $this->SSN;
    }
    /**
     * Set SSN value
     * @param string $sSN
     * @return \StructType\ByName
     */
    public function setSSN($sSN = null)
    {
        // validation for constraint: string
        if (!is_null($sSN) && !is_string($sSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSN, true), gettype($sSN)), __LINE__);
        }
        $this->SSN = $sSN;
        return $this;
    }
}
