<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mission ServiceType
 * @subpackage Services
 */
class Mission extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Mission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Mission $parameters
     * @return \StructType\MissionResponse|bool
     */
    public function Mission(\StructType\Mission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Mission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MissionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
