<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonIdentificationPersonIdentification ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonIdentificationPersonIdentification extends AbstractStructArrayBase
{
    /**
     * The PersonIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonIdentification[]
     */
    public $PersonIdentification;
    /**
     * Constructor method for ArrayOfPersonIdentificationPersonIdentification
     * @uses ArrayOfPersonIdentificationPersonIdentification::setPersonIdentification()
     * @param \StructType\PersonIdentification[] $personIdentification
     */
    public function __construct(array $personIdentification = array())
    {
        $this
            ->setPersonIdentification($personIdentification);
    }
    /**
     * Get PersonIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonIdentification[]|null
     */
    public function getPersonIdentification()
    {
        return isset($this->PersonIdentification) ? $this->PersonIdentification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonIdentificationForArrayConstraintsFromSetPersonIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem instanceof \StructType\PersonIdentification) {
                $invalidValues[] = is_object($arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem) ? get_class($arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem) : sprintf('%s(%s)', gettype($arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem), var_export($arrayOfPersonIdentificationPersonIdentificationPersonIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonIdentification property can only contain items of type \StructType\PersonIdentification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonIdentification[] $personIdentification
     * @return \ArrayType\ArrayOfPersonIdentificationPersonIdentification
     */
    public function setPersonIdentification(array $personIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($personIdentificationArrayErrorMessage = self::validatePersonIdentificationForArrayConstraintsFromSetPersonIdentification($personIdentification))) {
            throw new \InvalidArgumentException($personIdentificationArrayErrorMessage, __LINE__);
        }
        if (is_null($personIdentification) || (is_array($personIdentification) && empty($personIdentification))) {
            unset($this->PersonIdentification);
        } else {
            $this->PersonIdentification = $personIdentification;
        }
        return $this;
    }
    /**
     * Add item to PersonIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonIdentification $item
     * @return \ArrayType\ArrayOfPersonIdentificationPersonIdentification
     */
    public function addToPersonIdentification(\StructType\PersonIdentification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonIdentification) {
            throw new \InvalidArgumentException(sprintf('The PersonIdentification property can only contain items of type \StructType\PersonIdentification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonIdentification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonIdentification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonIdentification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonIdentification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonIdentification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonIdentification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonIdentification
     */
    public function getAttributeName()
    {
        return 'PersonIdentification';
    }
}
