<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFavoriteColorsItemString ArrayType
 * @subpackage Arrays
 */
class ArrayOfFavoriteColorsItemString extends AbstractStructArrayBase
{
    /**
     * The FavoriteColorsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $FavoriteColorsItem;
    /**
     * Constructor method for ArrayOfFavoriteColorsItemString
     * @uses ArrayOfFavoriteColorsItemString::setFavoriteColorsItem()
     * @param string[] $favoriteColorsItem
     */
    public function __construct(array $favoriteColorsItem = array())
    {
        $this
            ->setFavoriteColorsItem($favoriteColorsItem);
    }
    /**
     * Get FavoriteColorsItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFavoriteColorsItem()
    {
        return isset($this->FavoriteColorsItem) ? $this->FavoriteColorsItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFavoriteColorsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFavoriteColorsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFavoriteColorsItemForArrayConstraintsFromSetFavoriteColorsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFavoriteColorsItemStringFavoriteColorsItemItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfFavoriteColorsItemStringFavoriteColorsItemItem)) {
                $invalidValues[] = is_object($arrayOfFavoriteColorsItemStringFavoriteColorsItemItem) ? get_class($arrayOfFavoriteColorsItemStringFavoriteColorsItemItem) : sprintf('%s(%s)', gettype($arrayOfFavoriteColorsItemStringFavoriteColorsItemItem), var_export($arrayOfFavoriteColorsItemStringFavoriteColorsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FavoriteColorsItem property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FavoriteColorsItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $favoriteColorsItem
     * @return \ArrayType\ArrayOfFavoriteColorsItemString
     */
    public function setFavoriteColorsItem(array $favoriteColorsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($favoriteColorsItemArrayErrorMessage = self::validateFavoriteColorsItemForArrayConstraintsFromSetFavoriteColorsItem($favoriteColorsItem))) {
            throw new \InvalidArgumentException($favoriteColorsItemArrayErrorMessage, __LINE__);
        }
        if (is_null($favoriteColorsItem) || (is_array($favoriteColorsItem) && empty($favoriteColorsItem))) {
            unset($this->FavoriteColorsItem);
        } else {
            $this->FavoriteColorsItem = $favoriteColorsItem;
        }
        return $this;
    }
    /**
     * Add item to FavoriteColorsItem value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfFavoriteColorsItemString
     */
    public function addToFavoriteColorsItem($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FavoriteColorsItem property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FavoriteColorsItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FavoriteColorsItem
     */
    public function getAttributeName()
    {
        return 'FavoriteColorsItem';
    }
}
