<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingRequest StructType
 * @subpackage Structs
 */
class TrackingRequest extends AbstractStructBase
{
    /**
     * The IsLiveRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLiveRequest;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientSiteOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderRef;
    /**
     * The ConsignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNo;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * Constructor method for TrackingRequest
     * @uses TrackingRequest::setIsLiveRequest()
     * @uses TrackingRequest::setExtensionData()
     * @uses TrackingRequest::setClientCode()
     * @uses TrackingRequest::setClientSiteOrderRef()
     * @uses TrackingRequest::setConsignmentNo()
     * @uses TrackingRequest::setUpi()
     * @param bool $isLiveRequest
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $clientSiteOrderRef
     * @param string $consignmentNo
     * @param string $upi
     */
    public function __construct($isLiveRequest = null, \StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $clientSiteOrderRef = null, $consignmentNo = null, $upi = null)
    {
        $this
            ->setIsLiveRequest($isLiveRequest)
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setClientSiteOrderRef($clientSiteOrderRef)
            ->setConsignmentNo($consignmentNo)
            ->setUpi($upi);
    }
    /**
     * Get IsLiveRequest value
     * @return bool
     */
    public function getIsLiveRequest()
    {
        return $this->IsLiveRequest;
    }
    /**
     * Set IsLiveRequest value
     * @param bool $isLiveRequest
     * @return \StructType\TrackingRequest
     */
    public function setIsLiveRequest($isLiveRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLiveRequest) && !is_bool($isLiveRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLiveRequest, true), gettype($isLiveRequest)), __LINE__);
        }
        $this->IsLiveRequest = $isLiveRequest;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\TrackingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\TrackingRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientSiteOrderRef value
     * @return string|null
     */
    public function getClientSiteOrderRef()
    {
        return $this->ClientSiteOrderRef;
    }
    /**
     * Set ClientSiteOrderRef value
     * @param string $clientSiteOrderRef
     * @return \StructType\TrackingRequest
     */
    public function setClientSiteOrderRef($clientSiteOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderRef) && !is_string($clientSiteOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderRef, true), gettype($clientSiteOrderRef)), __LINE__);
        }
        $this->ClientSiteOrderRef = $clientSiteOrderRef;
        return $this;
    }
    /**
     * Get ConsignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->ConsignmentNo;
    }
    /**
     * Set ConsignmentNo value
     * @param string $consignmentNo
     * @return \StructType\TrackingRequest
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->ConsignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\TrackingRequest
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
}
