<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestExportRequest StructType
 * @subpackage Structs
 */
class ManifestExportRequest extends AbstractStructBase
{
    /**
     * The IsMonthlySummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMonthlySummary;
    /**
     * The ManifestID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ManifestID;
    /**
     * The SummarySpan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\TimeSpan
     */
    public $SummarySpan;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * Constructor method for ManifestExportRequest
     * @uses ManifestExportRequest::setIsMonthlySummary()
     * @uses ManifestExportRequest::setManifestID()
     * @uses ManifestExportRequest::setSummarySpan()
     * @uses ManifestExportRequest::setExtensionData()
     * @uses ManifestExportRequest::setCarrierCode()
     * @param bool $isMonthlySummary
     * @param int $manifestID
     * @param \StructType\TimeSpan $summarySpan
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     */
    public function __construct($isMonthlySummary = null, $manifestID = null, \StructType\TimeSpan $summarySpan = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null)
    {
        $this
            ->setIsMonthlySummary($isMonthlySummary)
            ->setManifestID($manifestID)
            ->setSummarySpan($summarySpan)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode);
    }
    /**
     * Get IsMonthlySummary value
     * @return bool
     */
    public function getIsMonthlySummary()
    {
        return $this->IsMonthlySummary;
    }
    /**
     * Set IsMonthlySummary value
     * @param bool $isMonthlySummary
     * @return \StructType\ManifestExportRequest
     */
    public function setIsMonthlySummary($isMonthlySummary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMonthlySummary) && !is_bool($isMonthlySummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMonthlySummary, true), gettype($isMonthlySummary)), __LINE__);
        }
        $this->IsMonthlySummary = $isMonthlySummary;
        return $this;
    }
    /**
     * Get ManifestID value
     * @return int
     */
    public function getManifestID()
    {
        return $this->ManifestID;
    }
    /**
     * Set ManifestID value
     * @param int $manifestID
     * @return \StructType\ManifestExportRequest
     */
    public function setManifestID($manifestID = null)
    {
        // validation for constraint: int
        if (!is_null($manifestID) && !(is_int($manifestID) || ctype_digit($manifestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manifestID, true), gettype($manifestID)), __LINE__);
        }
        $this->ManifestID = $manifestID;
        return $this;
    }
    /**
     * Get SummarySpan value
     * @return \StructType\TimeSpan
     */
    public function getSummarySpan()
    {
        return $this->SummarySpan;
    }
    /**
     * Set SummarySpan value
     * @param \StructType\TimeSpan $summarySpan
     * @return \StructType\ManifestExportRequest
     */
    public function setSummarySpan(\StructType\TimeSpan $summarySpan = null)
    {
        $this->SummarySpan = $summarySpan;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ManifestExportRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ManifestExportRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
}
