<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScriptsRun StructType
 * @subpackage Structs
 */
class GetScriptsRun extends AbstractStructBase
{
    /**
     * The page
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $page;
    /**
     * The sortOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sortOrder;
    /**
     * The getLabels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $getLabels;
    /**
     * The sortColumnName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortColumnName;
    /**
     * Constructor method for GetScriptsRun
     * @uses GetScriptsRun::setPage()
     * @uses GetScriptsRun::setSortOrder()
     * @uses GetScriptsRun::setGetLabels()
     * @uses GetScriptsRun::setSortColumnName()
     * @param int $page
     * @param string $sortOrder
     * @param bool $getLabels
     * @param string $sortColumnName
     */
    public function __construct($page = null, $sortOrder = null, $getLabels = null, $sortColumnName = null)
    {
        $this
            ->setPage($page)
            ->setSortOrder($sortOrder)
            ->setGetLabels($getLabels)
            ->setSortColumnName($sortColumnName);
    }
    /**
     * Get page value
     * @return int
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param int $page
     * @return \StructType\GetScriptsRun
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return string
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\GridSortOrder::valueIsValid()
     * @uses \EnumType\GridSortOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\GetScriptsRun
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GridSortOrder::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GridSortOrder', is_array($sortOrder) ? implode(', ', $sortOrder) : var_export($sortOrder, true), implode(', ', \EnumType\GridSortOrder::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get getLabels value
     * @return bool
     */
    public function getGetLabels()
    {
        return $this->getLabels;
    }
    /**
     * Set getLabels value
     * @param bool $getLabels
     * @return \StructType\GetScriptsRun
     */
    public function setGetLabels($getLabels = null)
    {
        // validation for constraint: boolean
        if (!is_null($getLabels) && !is_bool($getLabels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getLabels, true), gettype($getLabels)), __LINE__);
        }
        $this->getLabels = $getLabels;
        return $this;
    }
    /**
     * Get sortColumnName value
     * @return string|null
     */
    public function getSortColumnName()
    {
        return $this->sortColumnName;
    }
    /**
     * Set sortColumnName value
     * @param string $sortColumnName
     * @return \StructType\GetScriptsRun
     */
    public function setSortColumnName($sortColumnName = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumnName) && !is_string($sortColumnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortColumnName, true), gettype($sortColumnName)), __LINE__);
        }
        $this->sortColumnName = $sortColumnName;
        return $this;
    }
}
