<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportBookingRequest StructType
 * @subpackage Structs
 */
class ExportBookingRequest extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BookingID;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The SiteCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteCode;
    /**
     * Constructor method for ExportBookingRequest
     * @uses ExportBookingRequest::setBookingID()
     * @uses ExportBookingRequest::setExtensionData()
     * @uses ExportBookingRequest::setCarrierCode()
     * @uses ExportBookingRequest::setSiteCode()
     * @param int $bookingID
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $siteCode
     */
    public function __construct($bookingID = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $siteCode = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setSiteCode($siteCode);
    }
    /**
     * Get BookingID value
     * @return int
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\ExportBookingRequest
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ExportBookingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ExportBookingRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get SiteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->SiteCode;
    }
    /**
     * Set SiteCode value
     * @param string $siteCode
     * @return \StructType\ExportBookingRequest
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCode, true), gettype($siteCode)), __LINE__);
        }
        $this->SiteCode = $siteCode;
        return $this;
    }
}
