<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventInfo StructType
 * @subpackage Structs
 */
class EventInfo extends AbstractStructBase
{
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedAt;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientOrderRef;
    /**
     * The ClientSiteOrderRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderRef;
    /**
     * The ConsignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNo;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCode;
    /**
     * The EventDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDesc;
    /**
     * The NormalisedCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NormalisedCode;
    /**
     * The NormalisedDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NormalisedDesc;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * Constructor method for EventInfo
     * @uses EventInfo::setCreatedAt()
     * @uses EventInfo::setExtensionData()
     * @uses EventInfo::setCarrierCode()
     * @uses EventInfo::setClientCode()
     * @uses EventInfo::setClientOrderRef()
     * @uses EventInfo::setClientSiteOrderRef()
     * @uses EventInfo::setConsignmentNo()
     * @uses EventInfo::setEventCode()
     * @uses EventInfo::setEventDesc()
     * @uses EventInfo::setNormalisedCode()
     * @uses EventInfo::setNormalisedDesc()
     * @uses EventInfo::setUpi()
     * @param string $createdAt
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $clientCode
     * @param string $clientOrderRef
     * @param string $clientSiteOrderRef
     * @param string $consignmentNo
     * @param string $eventCode
     * @param string $eventDesc
     * @param string $normalisedCode
     * @param string $normalisedDesc
     * @param string $upi
     */
    public function __construct($createdAt = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $clientCode = null, $clientOrderRef = null, $clientSiteOrderRef = null, $consignmentNo = null, $eventCode = null, $eventDesc = null, $normalisedCode = null, $normalisedDesc = null, $upi = null)
    {
        $this
            ->setCreatedAt($createdAt)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setClientCode($clientCode)
            ->setClientOrderRef($clientOrderRef)
            ->setClientSiteOrderRef($clientSiteOrderRef)
            ->setConsignmentNo($consignmentNo)
            ->setEventCode($eventCode)
            ->setEventDesc($eventDesc)
            ->setNormalisedCode($normalisedCode)
            ->setNormalisedDesc($normalisedDesc)
            ->setUpi($upi);
    }
    /**
     * Get CreatedAt value
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->CreatedAt;
    }
    /**
     * Set CreatedAt value
     * @param string $createdAt
     * @return \StructType\EventInfo
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->CreatedAt = $createdAt;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\EventInfo
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\EventInfo
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\EventInfo
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientOrderRef value
     * @return string|null
     */
    public function getClientOrderRef()
    {
        return $this->ClientOrderRef;
    }
    /**
     * Set ClientOrderRef value
     * @param string $clientOrderRef
     * @return \StructType\EventInfo
     */
    public function setClientOrderRef($clientOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($clientOrderRef) && !is_string($clientOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientOrderRef, true), gettype($clientOrderRef)), __LINE__);
        }
        $this->ClientOrderRef = $clientOrderRef;
        return $this;
    }
    /**
     * Get ClientSiteOrderRef value
     * @return string|null
     */
    public function getClientSiteOrderRef()
    {
        return $this->ClientSiteOrderRef;
    }
    /**
     * Set ClientSiteOrderRef value
     * @param string $clientSiteOrderRef
     * @return \StructType\EventInfo
     */
    public function setClientSiteOrderRef($clientSiteOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderRef) && !is_string($clientSiteOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderRef, true), gettype($clientSiteOrderRef)), __LINE__);
        }
        $this->ClientSiteOrderRef = $clientSiteOrderRef;
        return $this;
    }
    /**
     * Get ConsignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->ConsignmentNo;
    }
    /**
     * Set ConsignmentNo value
     * @param string $consignmentNo
     * @return \StructType\EventInfo
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->ConsignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\EventInfo
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventDesc value
     * @return string|null
     */
    public function getEventDesc()
    {
        return $this->EventDesc;
    }
    /**
     * Set EventDesc value
     * @param string $eventDesc
     * @return \StructType\EventInfo
     */
    public function setEventDesc($eventDesc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDesc) && !is_string($eventDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDesc, true), gettype($eventDesc)), __LINE__);
        }
        $this->EventDesc = $eventDesc;
        return $this;
    }
    /**
     * Get NormalisedCode value
     * @return string|null
     */
    public function getNormalisedCode()
    {
        return $this->NormalisedCode;
    }
    /**
     * Set NormalisedCode value
     * @param string $normalisedCode
     * @return \StructType\EventInfo
     */
    public function setNormalisedCode($normalisedCode = null)
    {
        // validation for constraint: string
        if (!is_null($normalisedCode) && !is_string($normalisedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalisedCode, true), gettype($normalisedCode)), __LINE__);
        }
        $this->NormalisedCode = $normalisedCode;
        return $this;
    }
    /**
     * Get NormalisedDesc value
     * @return string|null
     */
    public function getNormalisedDesc()
    {
        return $this->NormalisedDesc;
    }
    /**
     * Set NormalisedDesc value
     * @param string $normalisedDesc
     * @return \StructType\EventInfo
     */
    public function setNormalisedDesc($normalisedDesc = null)
    {
        // validation for constraint: string
        if (!is_null($normalisedDesc) && !is_string($normalisedDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalisedDesc, true), gettype($normalisedDesc)), __LINE__);
        }
        $this->NormalisedDesc = $normalisedDesc;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\EventInfo
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
}
