<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchAllocatingResponse StructType
 * @subpackage Structs
 */
class DespatchAllocatingResponse extends AbstractStructBase
{
    /**
     * The BasicCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BasicCost;
    /**
     * The DespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DespatchDate;
    /**
     * The FinalDeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FinalDeliveryDate;
    /**
     * The IncrementalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IncrementalCost;
    /**
     * The Successful
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Successful;
    /**
     * The SurchargeTotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SurchargeTotalCost;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCost;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The ClientDespatchMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchMethod;
    /**
     * The ClientDespatchMethodDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchMethodDescription;
    /**
     * The ClientDespatchMethodsInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClientDespatchMethodInformation
     */
    public $ClientDespatchMethodsInformation;
    /**
     * The ConsignmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNumber;
    /**
     * The ContractNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractNumber;
    /**
     * The ParcelInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParcelInformation;
    /**
     * The RejectionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RejectionReason;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSurchargeMember
     */
    public $Surcharges;
    /**
     * Constructor method for DespatchAllocatingResponse
     * @uses DespatchAllocatingResponse::setBasicCost()
     * @uses DespatchAllocatingResponse::setDespatchDate()
     * @uses DespatchAllocatingResponse::setFinalDeliveryDate()
     * @uses DespatchAllocatingResponse::setIncrementalCost()
     * @uses DespatchAllocatingResponse::setSuccessful()
     * @uses DespatchAllocatingResponse::setSurchargeTotalCost()
     * @uses DespatchAllocatingResponse::setTotalCost()
     * @uses DespatchAllocatingResponse::setExtensionData()
     * @uses DespatchAllocatingResponse::setCarrierCode()
     * @uses DespatchAllocatingResponse::setCarrierName()
     * @uses DespatchAllocatingResponse::setClientDespatchMethod()
     * @uses DespatchAllocatingResponse::setClientDespatchMethodDescription()
     * @uses DespatchAllocatingResponse::setClientDespatchMethodsInformation()
     * @uses DespatchAllocatingResponse::setConsignmentNumber()
     * @uses DespatchAllocatingResponse::setContractNumber()
     * @uses DespatchAllocatingResponse::setParcelInformation()
     * @uses DespatchAllocatingResponse::setRejectionReason()
     * @uses DespatchAllocatingResponse::setSurcharges()
     * @param float $basicCost
     * @param string $despatchDate
     * @param string $finalDeliveryDate
     * @param float $incrementalCost
     * @param bool $successful
     * @param float $surchargeTotalCost
     * @param float $totalCost
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $carrierName
     * @param string $clientDespatchMethod
     * @param string $clientDespatchMethodDescription
     * @param \ArrayType\ArrayOfClientDespatchMethodInformation $clientDespatchMethodsInformation
     * @param string $consignmentNumber
     * @param string $contractNumber
     * @param string $parcelInformation
     * @param string $rejectionReason
     * @param \ArrayType\ArrayOfSurchargeMember $surcharges
     */
    public function __construct($basicCost = null, $despatchDate = null, $finalDeliveryDate = null, $incrementalCost = null, $successful = null, $surchargeTotalCost = null, $totalCost = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $carrierName = null, $clientDespatchMethod = null, $clientDespatchMethodDescription = null, \ArrayType\ArrayOfClientDespatchMethodInformation $clientDespatchMethodsInformation = null, $consignmentNumber = null, $contractNumber = null, $parcelInformation = null, $rejectionReason = null, \ArrayType\ArrayOfSurchargeMember $surcharges = null)
    {
        $this
            ->setBasicCost($basicCost)
            ->setDespatchDate($despatchDate)
            ->setFinalDeliveryDate($finalDeliveryDate)
            ->setIncrementalCost($incrementalCost)
            ->setSuccessful($successful)
            ->setSurchargeTotalCost($surchargeTotalCost)
            ->setTotalCost($totalCost)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setCarrierName($carrierName)
            ->setClientDespatchMethod($clientDespatchMethod)
            ->setClientDespatchMethodDescription($clientDespatchMethodDescription)
            ->setClientDespatchMethodsInformation($clientDespatchMethodsInformation)
            ->setConsignmentNumber($consignmentNumber)
            ->setContractNumber($contractNumber)
            ->setParcelInformation($parcelInformation)
            ->setRejectionReason($rejectionReason)
            ->setSurcharges($surcharges);
    }
    /**
     * Get BasicCost value
     * @return float
     */
    public function getBasicCost()
    {
        return $this->BasicCost;
    }
    /**
     * Set BasicCost value
     * @param float $basicCost
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setBasicCost($basicCost = null)
    {
        // validation for constraint: float
        if (!is_null($basicCost) && !(is_float($basicCost) || is_numeric($basicCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basicCost, true), gettype($basicCost)), __LINE__);
        }
        $this->BasicCost = $basicCost;
        return $this;
    }
    /**
     * Get DespatchDate value
     * @return string
     */
    public function getDespatchDate()
    {
        return $this->DespatchDate;
    }
    /**
     * Set DespatchDate value
     * @param string $despatchDate
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setDespatchDate($despatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchDate) && !is_string($despatchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchDate, true), gettype($despatchDate)), __LINE__);
        }
        $this->DespatchDate = $despatchDate;
        return $this;
    }
    /**
     * Get FinalDeliveryDate value
     * @return string
     */
    public function getFinalDeliveryDate()
    {
        return $this->FinalDeliveryDate;
    }
    /**
     * Set FinalDeliveryDate value
     * @param string $finalDeliveryDate
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setFinalDeliveryDate($finalDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($finalDeliveryDate) && !is_string($finalDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finalDeliveryDate, true), gettype($finalDeliveryDate)), __LINE__);
        }
        $this->FinalDeliveryDate = $finalDeliveryDate;
        return $this;
    }
    /**
     * Get IncrementalCost value
     * @return float
     */
    public function getIncrementalCost()
    {
        return $this->IncrementalCost;
    }
    /**
     * Set IncrementalCost value
     * @param float $incrementalCost
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setIncrementalCost($incrementalCost = null)
    {
        // validation for constraint: float
        if (!is_null($incrementalCost) && !(is_float($incrementalCost) || is_numeric($incrementalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incrementalCost, true), gettype($incrementalCost)), __LINE__);
        }
        $this->IncrementalCost = $incrementalCost;
        return $this;
    }
    /**
     * Get Successful value
     * @return bool
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get SurchargeTotalCost value
     * @return float
     */
    public function getSurchargeTotalCost()
    {
        return $this->SurchargeTotalCost;
    }
    /**
     * Set SurchargeTotalCost value
     * @param float $surchargeTotalCost
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setSurchargeTotalCost($surchargeTotalCost = null)
    {
        // validation for constraint: float
        if (!is_null($surchargeTotalCost) && !(is_float($surchargeTotalCost) || is_numeric($surchargeTotalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surchargeTotalCost, true), gettype($surchargeTotalCost)), __LINE__);
        }
        $this->SurchargeTotalCost = $surchargeTotalCost;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get ClientDespatchMethod value
     * @return string|null
     */
    public function getClientDespatchMethod()
    {
        return $this->ClientDespatchMethod;
    }
    /**
     * Set ClientDespatchMethod value
     * @param string $clientDespatchMethod
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setClientDespatchMethod($clientDespatchMethod = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchMethod) && !is_string($clientDespatchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchMethod, true), gettype($clientDespatchMethod)), __LINE__);
        }
        $this->ClientDespatchMethod = $clientDespatchMethod;
        return $this;
    }
    /**
     * Get ClientDespatchMethodDescription value
     * @return string|null
     */
    public function getClientDespatchMethodDescription()
    {
        return $this->ClientDespatchMethodDescription;
    }
    /**
     * Set ClientDespatchMethodDescription value
     * @param string $clientDespatchMethodDescription
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setClientDespatchMethodDescription($clientDespatchMethodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchMethodDescription) && !is_string($clientDespatchMethodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchMethodDescription, true), gettype($clientDespatchMethodDescription)), __LINE__);
        }
        $this->ClientDespatchMethodDescription = $clientDespatchMethodDescription;
        return $this;
    }
    /**
     * Get ClientDespatchMethodsInformation value
     * @return \ArrayType\ArrayOfClientDespatchMethodInformation|null
     */
    public function getClientDespatchMethodsInformation()
    {
        return $this->ClientDespatchMethodsInformation;
    }
    /**
     * Set ClientDespatchMethodsInformation value
     * @param \ArrayType\ArrayOfClientDespatchMethodInformation $clientDespatchMethodsInformation
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setClientDespatchMethodsInformation(\ArrayType\ArrayOfClientDespatchMethodInformation $clientDespatchMethodsInformation = null)
    {
        $this->ClientDespatchMethodsInformation = $clientDespatchMethodsInformation;
        return $this;
    }
    /**
     * Get ConsignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->ConsignmentNumber;
    }
    /**
     * Set ConsignmentNumber value
     * @param string $consignmentNumber
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNumber, true), gettype($consignmentNumber)), __LINE__);
        }
        $this->ConsignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get ParcelInformation value
     * @return string|null
     */
    public function getParcelInformation()
    {
        return $this->ParcelInformation;
    }
    /**
     * Set ParcelInformation value
     * @param string $parcelInformation
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setParcelInformation($parcelInformation = null)
    {
        // validation for constraint: string
        if (!is_null($parcelInformation) && !is_string($parcelInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelInformation, true), gettype($parcelInformation)), __LINE__);
        }
        $this->ParcelInformation = $parcelInformation;
        return $this;
    }
    /**
     * Get RejectionReason value
     * @return string|null
     */
    public function getRejectionReason()
    {
        return $this->RejectionReason;
    }
    /**
     * Set RejectionReason value
     * @param string $rejectionReason
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setRejectionReason($rejectionReason = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionReason) && !is_string($rejectionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionReason, true), gettype($rejectionReason)), __LINE__);
        }
        $this->RejectionReason = $rejectionReason;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \ArrayType\ArrayOfSurchargeMember|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @param \ArrayType\ArrayOfSurchargeMember $surcharges
     * @return \StructType\DespatchAllocatingResponse
     */
    public function setSurcharges(\ArrayType\ArrayOfSurchargeMember $surcharges = null)
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
}
