<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createlabelrequest StructType
 * @subpackage Structs
 */
class Createlabelrequest extends DespatchBaseRequest
{
    /**
     * The ClientOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientOrderReference;
    /**
     * The ConsignmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNumber;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The Customs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomsInfo
     */
    public $Customs;
    /**
     * The DeliveryStoreName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStoreName;
    /**
     * The LabelReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelReference;
    /**
     * The Labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLabel
     */
    public $Labels;
    /**
     * The Longest2DimensionItemSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longest2DimensionItemSum;
    /**
     * The Longest2DimensionSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longest2DimensionSum;
    /**
     * The PalletSortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PalletSortName;
    /**
     * The Parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParcel
     */
    public $Parcels;
    /**
     * The PreDespatched
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PreDespatched;
    /**
     * The PrintType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrintType;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProduct
     */
    public $Products;
    /**
     * The SafePlace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafePlace;
    /**
     * The SumOfDimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $SumOfDimensions;
    /**
     * The TotalPackagingWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPackagingWeight;
    /**
     * Constructor method for createlabelrequest
     * @uses Createlabelrequest::setClientOrderReference()
     * @uses Createlabelrequest::setConsignmentNumber()
     * @uses Createlabelrequest::setCustomerNumber()
     * @uses Createlabelrequest::setCustoms()
     * @uses Createlabelrequest::setDeliveryStoreName()
     * @uses Createlabelrequest::setLabelReference()
     * @uses Createlabelrequest::setLabels()
     * @uses Createlabelrequest::setLongest2DimensionItemSum()
     * @uses Createlabelrequest::setLongest2DimensionSum()
     * @uses Createlabelrequest::setPalletSortName()
     * @uses Createlabelrequest::setParcels()
     * @uses Createlabelrequest::setPreDespatched()
     * @uses Createlabelrequest::setPrintType()
     * @uses Createlabelrequest::setProducts()
     * @uses Createlabelrequest::setSafePlace()
     * @uses Createlabelrequest::setSumOfDimensions()
     * @uses Createlabelrequest::setTotalPackagingWeight()
     * @param string $clientOrderReference
     * @param string $consignmentNumber
     * @param string $customerNumber
     * @param \StructType\CustomsInfo $customs
     * @param string $deliveryStoreName
     * @param string $labelReference
     * @param \ArrayType\ArrayOfLabel $labels
     * @param float $longest2DimensionItemSum
     * @param float $longest2DimensionSum
     * @param string $palletSortName
     * @param \ArrayType\ArrayOfParcel $parcels
     * @param bool $preDespatched
     * @param string $printType
     * @param \ArrayType\ArrayOfProduct $products
     * @param string $safePlace
     * @param float $sumOfDimensions
     * @param float $totalPackagingWeight
     */
    public function __construct($clientOrderReference = null, $consignmentNumber = null, $customerNumber = null, \StructType\CustomsInfo $customs = null, $deliveryStoreName = null, $labelReference = null, \ArrayType\ArrayOfLabel $labels = null, $longest2DimensionItemSum = null, $longest2DimensionSum = null, $palletSortName = null, \ArrayType\ArrayOfParcel $parcels = null, $preDespatched = null, $printType = null, \ArrayType\ArrayOfProduct $products = null, $safePlace = null, $sumOfDimensions = null, $totalPackagingWeight = null)
    {
        $this
            ->setClientOrderReference($clientOrderReference)
            ->setConsignmentNumber($consignmentNumber)
            ->setCustomerNumber($customerNumber)
            ->setCustoms($customs)
            ->setDeliveryStoreName($deliveryStoreName)
            ->setLabelReference($labelReference)
            ->setLabels($labels)
            ->setLongest2DimensionItemSum($longest2DimensionItemSum)
            ->setLongest2DimensionSum($longest2DimensionSum)
            ->setPalletSortName($palletSortName)
            ->setParcels($parcels)
            ->setPreDespatched($preDespatched)
            ->setPrintType($printType)
            ->setProducts($products)
            ->setSafePlace($safePlace)
            ->setSumOfDimensions($sumOfDimensions)
            ->setTotalPackagingWeight($totalPackagingWeight);
    }
    /**
     * Get ClientOrderReference value
     * @return string|null
     */
    public function getClientOrderReference()
    {
        return $this->ClientOrderReference;
    }
    /**
     * Set ClientOrderReference value
     * @param string $clientOrderReference
     * @return \StructType\Createlabelrequest
     */
    public function setClientOrderReference($clientOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientOrderReference) && !is_string($clientOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientOrderReference, true), gettype($clientOrderReference)), __LINE__);
        }
        $this->ClientOrderReference = $clientOrderReference;
        return $this;
    }
    /**
     * Get ConsignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->ConsignmentNumber;
    }
    /**
     * Set ConsignmentNumber value
     * @param string $consignmentNumber
     * @return \StructType\Createlabelrequest
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNumber, true), gettype($consignmentNumber)), __LINE__);
        }
        $this->ConsignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\Createlabelrequest
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get Customs value
     * @return \StructType\CustomsInfo|null
     */
    public function getCustoms()
    {
        return $this->Customs;
    }
    /**
     * Set Customs value
     * @param \StructType\CustomsInfo $customs
     * @return \StructType\Createlabelrequest
     */
    public function setCustoms(\StructType\CustomsInfo $customs = null)
    {
        $this->Customs = $customs;
        return $this;
    }
    /**
     * Get DeliveryStoreName value
     * @return string|null
     */
    public function getDeliveryStoreName()
    {
        return $this->DeliveryStoreName;
    }
    /**
     * Set DeliveryStoreName value
     * @param string $deliveryStoreName
     * @return \StructType\Createlabelrequest
     */
    public function setDeliveryStoreName($deliveryStoreName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStoreName) && !is_string($deliveryStoreName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStoreName, true), gettype($deliveryStoreName)), __LINE__);
        }
        $this->DeliveryStoreName = $deliveryStoreName;
        return $this;
    }
    /**
     * Get LabelReference value
     * @return string|null
     */
    public function getLabelReference()
    {
        return $this->LabelReference;
    }
    /**
     * Set LabelReference value
     * @param string $labelReference
     * @return \StructType\Createlabelrequest
     */
    public function setLabelReference($labelReference = null)
    {
        // validation for constraint: string
        if (!is_null($labelReference) && !is_string($labelReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelReference, true), gettype($labelReference)), __LINE__);
        }
        $this->LabelReference = $labelReference;
        return $this;
    }
    /**
     * Get Labels value
     * @return \ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return $this->Labels;
    }
    /**
     * Set Labels value
     * @param \ArrayType\ArrayOfLabel $labels
     * @return \StructType\Createlabelrequest
     */
    public function setLabels(\ArrayType\ArrayOfLabel $labels = null)
    {
        $this->Labels = $labels;
        return $this;
    }
    /**
     * Get Longest2DimensionItemSum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongest2DimensionItemSum()
    {
        return isset($this->Longest2DimensionItemSum) ? $this->Longest2DimensionItemSum : null;
    }
    /**
     * Set Longest2DimensionItemSum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longest2DimensionItemSum
     * @return \StructType\Createlabelrequest
     */
    public function setLongest2DimensionItemSum($longest2DimensionItemSum = null)
    {
        // validation for constraint: float
        if (!is_null($longest2DimensionItemSum) && !(is_float($longest2DimensionItemSum) || is_numeric($longest2DimensionItemSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longest2DimensionItemSum, true), gettype($longest2DimensionItemSum)), __LINE__);
        }
        if (is_null($longest2DimensionItemSum) || (is_array($longest2DimensionItemSum) && empty($longest2DimensionItemSum))) {
            unset($this->Longest2DimensionItemSum);
        } else {
            $this->Longest2DimensionItemSum = $longest2DimensionItemSum;
        }
        return $this;
    }
    /**
     * Get Longest2DimensionSum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongest2DimensionSum()
    {
        return isset($this->Longest2DimensionSum) ? $this->Longest2DimensionSum : null;
    }
    /**
     * Set Longest2DimensionSum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longest2DimensionSum
     * @return \StructType\Createlabelrequest
     */
    public function setLongest2DimensionSum($longest2DimensionSum = null)
    {
        // validation for constraint: float
        if (!is_null($longest2DimensionSum) && !(is_float($longest2DimensionSum) || is_numeric($longest2DimensionSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longest2DimensionSum, true), gettype($longest2DimensionSum)), __LINE__);
        }
        if (is_null($longest2DimensionSum) || (is_array($longest2DimensionSum) && empty($longest2DimensionSum))) {
            unset($this->Longest2DimensionSum);
        } else {
            $this->Longest2DimensionSum = $longest2DimensionSum;
        }
        return $this;
    }
    /**
     * Get PalletSortName value
     * @return string|null
     */
    public function getPalletSortName()
    {
        return $this->PalletSortName;
    }
    /**
     * Set PalletSortName value
     * @param string $palletSortName
     * @return \StructType\Createlabelrequest
     */
    public function setPalletSortName($palletSortName = null)
    {
        // validation for constraint: string
        if (!is_null($palletSortName) && !is_string($palletSortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletSortName, true), gettype($palletSortName)), __LINE__);
        }
        $this->PalletSortName = $palletSortName;
        return $this;
    }
    /**
     * Get Parcels value
     * @return \ArrayType\ArrayOfParcel|null
     */
    public function getParcels()
    {
        return $this->Parcels;
    }
    /**
     * Set Parcels value
     * @param \ArrayType\ArrayOfParcel $parcels
     * @return \StructType\Createlabelrequest
     */
    public function setParcels(\ArrayType\ArrayOfParcel $parcels = null)
    {
        $this->Parcels = $parcels;
        return $this;
    }
    /**
     * Get PreDespatched value
     * @return bool|null
     */
    public function getPreDespatched()
    {
        return $this->PreDespatched;
    }
    /**
     * Set PreDespatched value
     * @param bool $preDespatched
     * @return \StructType\Createlabelrequest
     */
    public function setPreDespatched($preDespatched = null)
    {
        // validation for constraint: boolean
        if (!is_null($preDespatched) && !is_bool($preDespatched)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preDespatched, true), gettype($preDespatched)), __LINE__);
        }
        $this->PreDespatched = $preDespatched;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @uses \EnumType\PrintType::valueIsValid()
     * @uses \EnumType\PrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printType
     * @return \StructType\Createlabelrequest
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintType::valueIsValid($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintType', is_array($printType) ? implode(', ', $printType) : var_export($printType, true), implode(', ', \EnumType\PrintType::getValidValues())), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Get Products value
     * @return \ArrayType\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \ArrayType\ArrayOfProduct $products
     * @return \StructType\Createlabelrequest
     */
    public function setProducts(\ArrayType\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get SafePlace value
     * @return string|null
     */
    public function getSafePlace()
    {
        return $this->SafePlace;
    }
    /**
     * Set SafePlace value
     * @param string $safePlace
     * @return \StructType\Createlabelrequest
     */
    public function setSafePlace($safePlace = null)
    {
        // validation for constraint: string
        if (!is_null($safePlace) && !is_string($safePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safePlace, true), gettype($safePlace)), __LINE__);
        }
        $this->SafePlace = $safePlace;
        return $this;
    }
    /**
     * Get SumOfDimensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSumOfDimensions()
    {
        return isset($this->SumOfDimensions) ? $this->SumOfDimensions : null;
    }
    /**
     * Set SumOfDimensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $sumOfDimensions
     * @return \StructType\Createlabelrequest
     */
    public function setSumOfDimensions($sumOfDimensions = null)
    {
        // validation for constraint: float
        if (!is_null($sumOfDimensions) && !(is_float($sumOfDimensions) || is_numeric($sumOfDimensions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sumOfDimensions, true), gettype($sumOfDimensions)), __LINE__);
        }
        if (is_null($sumOfDimensions) || (is_array($sumOfDimensions) && empty($sumOfDimensions))) {
            unset($this->SumOfDimensions);
        } else {
            $this->SumOfDimensions = $sumOfDimensions;
        }
        return $this;
    }
    /**
     * Get TotalPackagingWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPackagingWeight()
    {
        return isset($this->TotalPackagingWeight) ? $this->TotalPackagingWeight : null;
    }
    /**
     * Set TotalPackagingWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPackagingWeight
     * @return \StructType\Createlabelrequest
     */
    public function setTotalPackagingWeight($totalPackagingWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalPackagingWeight) && !(is_float($totalPackagingWeight) || is_numeric($totalPackagingWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPackagingWeight, true), gettype($totalPackagingWeight)), __LINE__);
        }
        if (is_null($totalPackagingWeight) || (is_array($totalPackagingWeight) && empty($totalPackagingWeight))) {
            unset($this->TotalPackagingWeight);
        } else {
            $this->TotalPackagingWeight = $totalPackagingWeight;
        }
        return $this;
    }
}
