<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetMaintenanceMode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMaintenanceMode $parameters
     * @return \StructType\SetMaintenanceModeResponse|bool
     */
    public function SetMaintenanceMode(\StructType\SetMaintenanceMode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMaintenanceMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetMaintenanceModeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
