<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDiagnosticInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiagnosticInfo $parameters
     * @return \StructType\GetDiagnosticInfoResponse|bool
     */
    public function GetDiagnosticInfo(\StructType\GetDiagnosticInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDiagnosticInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSpeedTestInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSpeedTestInfo $parameters
     * @return \StructType\GetSpeedTestInfoResponse|bool
     */
    public function GetSpeedTestInfo(\StructType\GetSpeedTestInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSpeedTestInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetScriptsRun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetScriptsRun $parameters
     * @return \StructType\GetScriptsRunResponse|bool
     */
    public function GetScriptsRun(\StructType\GetScriptsRun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetScriptsRun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMaintenanceMode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMaintenanceMode $parameters
     * @return \StructType\GetMaintenanceModeResponse|bool
     */
    public function GetMaintenanceMode(\StructType\GetMaintenanceMode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMaintenanceMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManifestedOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetManifestedOrders $parameters
     * @return \StructType\GetManifestedOrdersResponse|bool
     */
    public function GetManifestedOrders(\StructType\GetManifestedOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManifestedOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTrackingEvents
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTrackingEvents $parameters
     * @return \StructType\GetTrackingEventsResponse|bool
     */
    public function GetTrackingEvents(\StructType\GetTrackingEvents $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTrackingEvents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDespatchDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDespatchDetails $parameters
     * @return \StructType\GetDespatchDetailsResponse|bool
     */
    public function GetDespatchDetails(\StructType\GetDespatchDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDespatchDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStores $parameters
     * @return \StructType\GetStoresResponse|bool
     */
    public function GetStores(\StructType\GetStores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDespatchManagerPrintRequestById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDespatchManagerPrintRequestById $parameters
     * @return \StructType\GetDespatchManagerPrintRequestByIdResponse|bool
     */
    public function GetDespatchManagerPrintRequestById(\StructType\GetDespatchManagerPrintRequestById $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDespatchManagerPrintRequestById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParcelPrintsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParcelPrintsCount $parameters
     * @return \StructType\GetParcelPrintsCountResponse|bool
     */
    public function GetParcelPrintsCount(\StructType\GetParcelPrintsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetParcelPrintsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderPrintsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderPrintsCount $parameters
     * @return \StructType\GetOrderPrintsCountResponse|bool
     */
    public function GetOrderPrintsCount(\StructType\GetOrderPrintsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderPrintsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDespatchDetailsResponse|\StructType\GetDespatchManagerPrintRequestByIdResponse|\StructType\GetDiagnosticInfoResponse|\StructType\GetMaintenanceModeResponse|\StructType\GetManifestedOrdersResponse|\StructType\GetOrderPrintsCountResponse|\StructType\GetParcelPrintsCountResponse|\StructType\GetScriptsRunResponse|\StructType\GetSpeedTestInfoResponse|\StructType\GetStoresResponse|\StructType\GetTrackingEventsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
