<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrder $parameters
     * @return \StructType\CreateOrderResponse|bool
     */
    public function CreateOrder(\StructType\CreateOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateBooking $parameters
     * @return \StructType\CreateBookingResponse|bool
     */
    public function CreateBooking(\StructType\CreateBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateManifest $parameters
     * @return \StructType\CreateManifestResponse|bool
     */
    public function CreateManifest(\StructType\CreateManifest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateManifest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTrackingEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateTrackingEvent $parameters
     * @return \StructType\CreateTrackingEventResponse|bool
     */
    public function CreateTrackingEvent(\StructType\CreateTrackingEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateTrackingEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNormalisedEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateNormalisedEvent $parameters
     * @return \StructType\CreateNormalisedEventResponse|bool
     */
    public function CreateNormalisedEvent(\StructType\CreateNormalisedEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateNormalisedEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePreDespatchedOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePreDespatchedOrder $parameters
     * @return \StructType\CreatePreDespatchedOrderResponse|bool
     */
    public function CreatePreDespatchedOrder(\StructType\CreatePreDespatchedOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePreDespatchedOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateBookingResponse|\StructType\CreateManifestResponse|\StructType\CreateNormalisedEventResponse|\StructType\CreateOrderResponse|\StructType\CreatePreDespatchedOrderResponse|\StructType\CreateTrackingEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
