<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PrintType EnumType
 * @subpackage Enumerations
 */
class PrintType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Print'
     * @return string 'Print'
     */
    const VALUE_PRINT = 'Print';
    /**
     * Constant for value 'EPL'
     * @return string 'EPL'
     */
    const VALUE_EPL = 'EPL';
    /**
     * Constant for value 'ZPL'
     * @return string 'ZPL'
     */
    const VALUE_ZPL = 'ZPL';
    /**
     * Constant for value 'JPG'
     * @return string 'JPG'
     */
    const VALUE_JPG = 'JPG';
    /**
     * Constant for value 'BMP'
     * @return string 'BMP'
     */
    const VALUE_BMP = 'BMP';
    /**
     * Constant for value 'PNG'
     * @return string 'PNG'
     */
    const VALUE_PNG = 'PNG';
    /**
     * Constant for value 'TIFF'
     * @return string 'TIFF'
     */
    const VALUE_TIFF = 'TIFF';
    /**
     * Constant for value 'PDF'
     * @return string 'PDF'
     */
    const VALUE_PDF = 'PDF';
    /**
     * Constant for value 'KeyValues'
     * @return string 'KeyValues'
     */
    const VALUE_KEY_VALUES = 'KeyValues';
    /**
     * Constant for value 'Thermal'
     * @return string 'Thermal'
     */
    const VALUE_THERMAL = 'Thermal';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return allowed values
     * @uses self::VALUE_PRINT
     * @uses self::VALUE_EPL
     * @uses self::VALUE_ZPL
     * @uses self::VALUE_JPG
     * @uses self::VALUE_BMP
     * @uses self::VALUE_PNG
     * @uses self::VALUE_TIFF
     * @uses self::VALUE_PDF
     * @uses self::VALUE_KEY_VALUES
     * @uses self::VALUE_THERMAL
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRINT,
            self::VALUE_EPL,
            self::VALUE_ZPL,
            self::VALUE_JPG,
            self::VALUE_BMP,
            self::VALUE_PNG,
            self::VALUE_TIFF,
            self::VALUE_PDF,
            self::VALUE_KEY_VALUES,
            self::VALUE_THERMAL,
            self::VALUE_NONE,
        );
    }
}
