<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingResponse StructType
 * @subpackage Structs
 */
class TrackingResponse extends ResultArgs
{
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEventInfo
     */
    public $Events;
    /**
     * Constructor method for TrackingResponse
     * @uses TrackingResponse::setCarrierCode()
     * @uses TrackingResponse::setEvents()
     * @param string $carrierCode
     * @param \ArrayType\ArrayOfEventInfo $events
     */
    public function __construct($carrierCode = null, \ArrayType\ArrayOfEventInfo $events = null)
    {
        $this
            ->setCarrierCode($carrierCode)
            ->setEvents($events);
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\TrackingResponse
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get Events value
     * @return \ArrayType\ArrayOfEventInfo|null
     */
    public function getEvents()
    {
        return $this->Events;
    }
    /**
     * Set Events value
     * @param \ArrayType\ArrayOfEventInfo $events
     * @return \StructType\TrackingResponse
     */
    public function setEvents(\ArrayType\ArrayOfEventInfo $events = null)
    {
        $this->Events = $events;
        return $this;
    }
}
